/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.DefaultMultiValueMap;
import cn.taketoday.core.UnmodifiableMultiValueMap;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;

public interface MultiValueMap<K, V>
extends Map<K, List<V>> {
    @Nullable
    public V getFirst(K var1);

    public void add(K var1, @Nullable V var2);

    default public void addAll(K key, @Nullable List<? extends V> values) {
        if (values != null) {
            for (V element : values) {
                this.add(key, element);
            }
        }
    }

    default public void addAll(K key, @Nullable Collection<? extends V> values) {
        if (values != null) {
            for (V element : values) {
                this.add(key, element);
            }
        }
    }

    default public void addAll(K key, @Nullable Enumeration<? extends V> values) {
        if (values != null) {
            while (values.hasMoreElements()) {
                V element = values.nextElement();
                this.add(key, element);
            }
        }
    }

    default public void addAll(@Nullable Map<K, List<V>> values) {
        if (values != null) {
            for (Map.Entry<K, List<V>> entry : values.entrySet()) {
                this.addAll(entry.getKey(), entry.getValue());
            }
        }
    }

    default public void addAll(Map.Entry<K, ? extends Collection<V>> pair) {
        this.addAll(pair.getKey(), pair.getValue());
    }

    default public void addIfAbsent(K key, @Nullable V value) {
        if (!this.containsKey(key)) {
            this.add(key, value);
        }
    }

    public void set(K var1, @Nullable V var2);

    default public void setAll(@Nullable Map<K, V> values) {
        if (values != null) {
            for (Map.Entry<K, V> entry : values.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
    }

    default public Map<K, V> toSingleValueMap() {
        HashMap singleValueMap = CollectionUtils.newHashMap(this.size());
        for (Map.Entry entry : this.entrySet()) {
            List values = (List)entry.getValue();
            if (!CollectionUtils.isNotEmpty(values)) continue;
            singleValueMap.put(entry.getKey(), values.get(0));
        }
        return singleValueMap;
    }

    default public Map<K, V[]> toArrayMap(IntFunction<V[]> function) {
        HashMap singleValueMap = CollectionUtils.newHashMap(this.size());
        this.copyToArrayMap(singleValueMap, function);
        return singleValueMap;
    }

    default public void copyToArrayMap(Map<K, V[]> newMap, IntFunction<V[]> mappingFunction) {
        Assert.notNull(newMap, "newMap must not be null");
        Assert.notNull(mappingFunction, "mappingFunction must not be null");
        for (Map.Entry entry : this.entrySet()) {
            List values = (List)entry.getValue();
            if (!CollectionUtils.isNotEmpty(values)) continue;
            V[] toArray = values.toArray(mappingFunction.apply(values.size()));
            newMap.put(entry.getKey(), (V[][])toArray);
        }
    }

    public static <K, V> DefaultMultiValueMap<K, V> defaults() {
        return new DefaultMultiValueMap();
    }

    public static <K, V> DefaultMultiValueMap<K, V> from(Map<K, List<V>> targetMap) {
        return new DefaultMultiValueMap<K, V>(targetMap);
    }

    public static <K, V> DefaultMultiValueMap<K, V> from(Map<K, List<V>> targetMap, Function<K, List<V>> mappingFunction) {
        return new DefaultMultiValueMap<K, V>(targetMap, mappingFunction);
    }

    public static <K, V> DefaultMultiValueMap<K, V> copyOf(Map<K, List<V>> targetMap) {
        return new DefaultMultiValueMap<K, V>(new LinkedHashMap<K, List<V>>(targetMap));
    }

    public static <K, V> DefaultMultiValueMap<K, V> copyOf(Map<K, List<V>> targetMap, Function<K, List<V>> mappingFunction) {
        return new DefaultMultiValueMap<K, V>(new LinkedHashMap<K, List<V>>(targetMap), mappingFunction);
    }

    public static <K, V> DefaultMultiValueMap<K, V> fromLinkedHashMap() {
        return MultiValueMap.from(new LinkedHashMap());
    }

    public static <K, V> DefaultMultiValueMap<K, V> fromLinkedHashMap(int initialCapacity) {
        return MultiValueMap.from(new LinkedHashMap(initialCapacity));
    }

    public static <K, V> MultiValueMap<K, V> unmodifiable(MultiValueMap<? extends K, ? extends V> targetMap) {
        Assert.notNull(targetMap, "'targetMap' must not be null");
        if (targetMap instanceof UnmodifiableMultiValueMap) {
            return targetMap;
        }
        return new UnmodifiableMultiValueMap<K, V>(targetMap);
    }
}

