/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.bytecode.ClassReader;
import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.core.ParameterNameDiscoverer;
import cn.taketoday.lang.Nullable;
import cn.taketoday.logging.Logger;
import cn.taketoday.logging.LoggerFactory;
import cn.taketoday.util.ClassUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class LocalVariableTableParameterNameDiscoverer
extends ParameterNameDiscoverer
implements Function<Class<?>, Map<Executable, String[]>> {
    private static final Logger log = LoggerFactory.getLogger(LocalVariableTableParameterNameDiscoverer.class);
    private static final Map<Executable, String[]> NO_DEBUG_INFO_MAP = Collections.emptyMap();
    private final ConcurrentHashMap<Class<?>, Map<Executable, String[]>> parameterNamesCache = new ConcurrentHashMap(32);

    @Override
    public String[] doGet(Executable executable) {
        Class<?> declaringClass = executable.getDeclaringClass();
        Map<Executable, String[]> map = this.parameterNamesCache.computeIfAbsent(declaringClass, this);
        return map != NO_DEBUG_INFO_MAP ? map.get(executable) : null;
    }

    @Override
    public Map<Executable, String[]> apply(Class<?> clazz) {
        return this.inspectClass(clazz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Executable, String[]> inspectClass(Class<?> clazz) {
        try (InputStream is = clazz.getResourceAsStream(ClassUtils.getClassFileName(clazz));){
            if (is == null) {
                log.debug("Cannot find '.class' file for class [{}] - unable to determine constructor/method parameter names", (Object)clazz);
                Map<Executable, String[]> map = NO_DEBUG_INFO_MAP;
                return map;
            }
            ClassReader classReader = new ClassReader(is);
            ConcurrentHashMap<Executable, String[]> map = new ConcurrentHashMap<Executable, String[]>(32);
            classReader.accept(new ParameterNameDiscoveringVisitor(clazz, map), 0);
            ConcurrentHashMap<Executable, String[]> concurrentHashMap = map;
            return concurrentHashMap;
        }
        catch (IOException ex) {
            log.debug("Exception thrown while reading '.class' file for class [{}] - unable to determine constructor/method parameter names", (Object)clazz, (Object)ex);
            return NO_DEBUG_INFO_MAP;
        }
        catch (IllegalArgumentException ex) {
            log.debug("ASM ClassReader failed to parse class file [{}], probably due to a new Java class file version that isn't supported yet - unable to determine constructor/method parameter names", (Object)clazz, (Object)ex);
        }
        return NO_DEBUG_INFO_MAP;
    }

    private static class ParameterNameDiscoveringVisitor
    extends ClassVisitor {
        private static final String STATIC_CLASS_INIT = "<clinit>";
        private final Class<?> clazz;
        private final Map<Executable, String[]> executableMap;

        public ParameterNameDiscoveringVisitor(Class<?> clazz, Map<Executable, String[]> executableMap) {
            this.clazz = clazz;
            this.executableMap = executableMap;
        }

        @Override
        @Nullable
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!ParameterNameDiscoveringVisitor.isSyntheticOrBridged(access) && !STATIC_CLASS_INIT.equals(name)) {
                return new LocalVariableTableVisitor(this.clazz, this.executableMap, name, desc, ParameterNameDiscoveringVisitor.isStatic(access));
            }
            return null;
        }

        private static boolean isSyntheticOrBridged(int access) {
            return (access & 0x1000 | access & 0x40) > 0;
        }

        private static boolean isStatic(int access) {
            return (access & 8) > 0;
        }
    }

    private static class LocalVariableTableVisitor
    extends MethodVisitor {
        private static final String CONSTRUCTOR = "<init>";
        private final String name;
        private final Type[] args;
        private final Class<?> clazz;
        private final boolean isStatic;
        private final String[] parameterNames;
        private final Map<Executable, String[]> executableMap;
        private boolean hasLvtInfo = false;
        private final int[] lvtSlotIndex;

        public LocalVariableTableVisitor(Class<?> clazz, Map<Executable, String[]> map, String name, String desc, boolean isStatic) {
            this.name = name;
            this.clazz = clazz;
            this.executableMap = map;
            this.isStatic = isStatic;
            this.args = Type.getArgumentTypes(desc);
            this.parameterNames = new String[this.args.length];
            this.lvtSlotIndex = LocalVariableTableVisitor.computeLvtSlotIndices(isStatic, this.args);
        }

        @Override
        public void visitLocalVariable(String name, String description, String signature, Label start, Label end, int index) {
            this.hasLvtInfo = true;
            for (int i = 0; i < this.lvtSlotIndex.length; ++i) {
                if (this.lvtSlotIndex[i] != index) continue;
                this.parameterNames[i] = name;
            }
        }

        @Override
        public void visitEnd() {
            if (this.hasLvtInfo || this.isStatic && this.parameterNames.length == 0) {
                this.executableMap.put(this.resolveExecutable(), this.parameterNames);
            }
        }

        private Executable resolveExecutable() {
            Type[] args = this.args;
            ClassLoader loader = this.clazz.getClassLoader();
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argTypes[i] = ClassUtils.resolveClassName(args[i].getClassName(), loader);
            }
            try {
                if (CONSTRUCTOR.equals(this.name)) {
                    return this.clazz.getDeclaredConstructor(argTypes);
                }
                return this.clazz.getDeclaredMethod(this.name, argTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Method [" + this.name + "] was discovered in the .class file but cannot be resolved in the class object", ex);
            }
        }

        private static int[] computeLvtSlotIndices(boolean isStatic, Type[] paramTypes) {
            int[] lvtIndex = new int[paramTypes.length];
            int nextIndex = isStatic ? 0 : 1;
            for (int i = 0; i < paramTypes.length; ++i) {
                lvtIndex[i] = nextIndex++;
                if (!LocalVariableTableVisitor.isWideType(paramTypes[i])) continue;
                nextIndex += 2;
            }
            return lvtIndex;
        }

        private static boolean isWideType(Type aType) {
            return aType == Type.LONG_TYPE || aType == Type.DOUBLE_TYPE;
        }
    }
}

