/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.core.AttributeAccessor;
import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Constant;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ObjectUtils;
import cn.taketoday.util.StringUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class AttributeAccessorSupport
implements AttributeAccessor,
Serializable {
    @Nullable
    protected Map<String, Object> attributes;

    @Override
    public void setAttribute(String name, @Nullable Object value) {
        if (value != null) {
            this.getAttributes().put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    @Override
    @Nullable
    public Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public <T> T computeAttribute(String name, Function<String, T> computeFunction) {
        Assert.notNull((Object)name, "Name must not be null");
        Assert.notNull(computeFunction, "Compute function must not be null");
        if (this.attributes == null) {
            T value = computeFunction.apply(name);
            if (value == null) {
                throw new IllegalStateException("Compute function must not return null for attribute named '" + name + "'");
            }
            this.setAttribute(name, value);
            return value;
        }
        Object value = this.attributes.computeIfAbsent(name, computeFunction);
        Assert.state(value != null, () -> String.format("Compute function must not return null for attribute named '%s'", name));
        return (T)value;
    }

    @Override
    public Object removeAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.remove(name);
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.containsKey(name);
        }
        return false;
    }

    @Override
    public String[] getAttributeNames() {
        if (this.attributes != null) {
            return StringUtils.toStringArray(this.attributes.keySet());
        }
        return Constant.EMPTY_STRING_ARRAY;
    }

    @Override
    public Iterator<String> attributeNames() {
        if (this.attributes != null) {
            return this.attributes.keySet().iterator();
        }
        return Collections.emptyIterator();
    }

    @Override
    public void copyAttributesFrom(AttributeAccessor source) {
        Map<String, Object> attributes;
        Assert.notNull((Object)source, "Source must not be null");
        if (source instanceof AttributeAccessorSupport) {
            attributes = ((AttributeAccessorSupport)source).attributes;
            if (attributes == null) {
                return;
            }
        } else {
            attributes = source.getAttributes();
        }
        if (CollectionUtils.isNotEmpty(attributes)) {
            this.getAttributes().putAll(attributes);
        }
    }

    @Override
    public void clearAttributes() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.attributes);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof AttributeAccessorSupport && Objects.equals(this.attributes, ((AttributeAccessorSupport)other).attributes);
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.createAttributes();
        }
        return this.attributes;
    }

    protected Map<String, Object> createAttributes() {
        return new HashMap<String, Object>();
    }
}

