/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.core;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import cn.taketoday.util.ArrayIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public interface AttributeAccessor {
    public void setAttribute(String var1, @Nullable Object var2);

    @Nullable
    public Object getAttribute(String var1);

    @Nullable
    public Object removeAttribute(String var1);

    public boolean hasAttribute(String var1);

    public String[] getAttributeNames();

    default public Iterator<String> attributeNames() {
        return new ArrayIterator<String>(this.getAttributeNames());
    }

    public boolean hasAttributes();

    public Map<String, Object> getAttributes();

    default public <T> T computeAttribute(String name, Function<String, T> computeFunction) {
        Assert.notNull((Object)name, "Name must not be null");
        Assert.notNull(computeFunction, "Compute function must not be null");
        Object value = this.getAttribute(name);
        if (value == null) {
            value = computeFunction.apply(name);
            if (value == null) {
                throw new IllegalStateException("Compute function must not return null for attribute named '" + name + "'");
            }
            this.setAttribute(name, value);
        }
        return (T)value;
    }

    public void copyAttributesFrom(AttributeAccessor var1);

    public void clearAttributes();
}

