/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.util;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.ObjectSwitchCallback;
import cn.taketoday.util.ReflectionUtils;
import java.util.Arrays;
import java.util.List;

public abstract class StringSwitcher {
    private static final Type STRING_SWITCHER = Type.fromClass(StringSwitcher.class);
    private static final MethodSignature INT_VALUE = MethodSignature.from("int intValue(String)");

    public static StringSwitcher create(String[] strings, int[] ints, boolean fixedInput) {
        Generator gen = new Generator();
        gen.setStrings(strings);
        gen.setInts(ints);
        gen.setFixedInput(fixedInput);
        return gen.create();
    }

    protected StringSwitcher() {
    }

    public abstract int intValue(String var1);

    public static class Generator
    extends AbstractClassGenerator {
        private int[] ints;
        private String[] strings;
        private boolean fixedInput;

        public Generator() {
            super(StringSwitcher.class);
        }

        public void setStrings(String[] strings) {
            this.strings = strings;
        }

        public void setInts(int[] ints) {
            this.ints = ints;
        }

        public void setFixedInput(boolean fixedInput) {
            this.fixedInput = fixedInput;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.getClass().getClassLoader();
        }

        public StringSwitcher create() {
            this.setNamePrefix(StringSwitcher.class.getName());
            StringSwitcherKey key = new StringSwitcherKey(Arrays.asList(this.strings), this.ints, this.fixedInput);
            return (StringSwitcher)super.create(key);
        }

        @Override
        public void generateClass(ClassVisitor v) throws Exception {
            ClassEmitter ce = new ClassEmitter(v);
            ce.beginClass(52, 1, this.getClassName(), STRING_SWITCHER, null, "<cglibGenerated>");
            EmitUtils.nullConstructor(ce);
            final CodeEmitter e = ce.beginMethod(1, INT_VALUE, new Type[0]);
            e.loadArg(0);
            final List<String> stringList = Arrays.asList(this.strings);
            int style = this.fixedInput ? 2 : 1;
            EmitUtils.stringSwitch(e, this.strings, style, new ObjectSwitchCallback(){

                @Override
                public void processCase(Object key, Label end) {
                    e.push(ints[stringList.indexOf(key)]);
                    e.returnValue();
                }

                @Override
                public void processDefault() {
                    e.push(-1);
                    e.returnValue();
                }
            });
            e.end_method();
            ce.endClass();
        }

        protected Object firstInstance(Class type) {
            return ReflectionUtils.newInstance(type);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }
    }

    record StringSwitcherKey(List<String> strings, int[] ints, boolean fixedInput) {
    }
}

