/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.util;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.Local;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.util.ParallelSorter;

class ParallelSorterEmitter
extends ClassEmitter {
    private static final Type PARALLEL_SORTER = Type.fromClass(ParallelSorter.class);
    private static final MethodSignature CSTRUCT_OBJECT_ARRAY = MethodSignature.forConstructor("Object[]");
    private static final MethodSignature NEW_INSTANCE = new MethodSignature(PARALLEL_SORTER, "newInstance", Type.TYPE_OBJECT_ARRAY);
    private static final MethodSignature SWAP = MethodSignature.from("void swap(int, int)");

    public ParallelSorterEmitter(ClassVisitor v, String className, Object[] arrays) {
        super(v);
        this.beginClass(52, 1, className, PARALLEL_SORTER, null, "<cglibGenerated>");
        EmitUtils.nullConstructor(this);
        EmitUtils.factoryMethod(this, NEW_INSTANCE);
        this.generateConstructor(arrays);
        this.generateSwap(arrays);
        this.endClass();
    }

    private String getFieldName(int index) {
        return "FIELD_" + index;
    }

    private void generateConstructor(Object[] arrays) {
        CodeEmitter e = this.beginMethod(1, CSTRUCT_OBJECT_ARRAY, new Type[0]);
        e.loadThis();
        e.super_invoke_constructor();
        e.loadThis();
        e.loadArg(0);
        e.super_putfield("a", Type.TYPE_OBJECT_ARRAY);
        for (int i = 0; i < arrays.length; ++i) {
            Type type = Type.fromClass(arrays[i].getClass());
            this.declare_field(2, this.getFieldName(i), type, null);
            e.loadThis();
            e.loadArg(0);
            e.push(i);
            e.aaload();
            e.checkCast(type);
            e.putField(this.getFieldName(i));
        }
        e.returnValue();
        e.end_method();
    }

    private void generateSwap(Object[] arrays) {
        CodeEmitter e = this.beginMethod(1, SWAP, new Type[0]);
        for (int i = 0; i < arrays.length; ++i) {
            Type type = Type.fromClass(arrays[i].getClass());
            Type component = type.getComponentType();
            Local T = e.newLocal(type);
            e.loadThis();
            e.getField(this.getFieldName(i));
            e.storeLocal(T);
            e.loadLocal(T);
            e.loadArg(0);
            e.loadLocal(T);
            e.loadArg(1);
            e.arrayLoad(component);
            e.loadLocal(T);
            e.loadArg(1);
            e.loadLocal(T);
            e.loadArg(0);
            e.arrayLoad(component);
            e.arrayStore(component);
            e.arrayStore(component);
        }
        e.returnValue();
        e.end_method();
    }
}

