/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.tree.analysis;

import cn.taketoday.bytecode.Opcodes;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.tree.AbstractInsnNode;
import cn.taketoday.bytecode.tree.FieldInsnNode;
import cn.taketoday.bytecode.tree.InvokeDynamicInsnNode;
import cn.taketoday.bytecode.tree.LdcInsnNode;
import cn.taketoday.bytecode.tree.MethodInsnNode;
import cn.taketoday.bytecode.tree.analysis.Interpreter;
import cn.taketoday.bytecode.tree.analysis.SmallSet;
import cn.taketoday.bytecode.tree.analysis.SourceValue;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SourceInterpreter
extends Interpreter<SourceValue>
implements Opcodes {
    @Override
    public SourceValue newValue(Type type) {
        if (type == Type.VOID_TYPE) {
            return null;
        }
        return new SourceValue(type == null ? 1 : type.getSize());
    }

    @Override
    public SourceValue newOperation(AbstractInsnNode insn) {
        return new SourceValue(switch (insn.getOpcode()) {
            case 9, 10, 14, 15 -> 2;
            case 18 -> {
                Object value = ((LdcInsnNode)insn).cst;
                yield value instanceof Long || value instanceof Double ? 2 : 1;
            }
            case 178 -> Type.fromDescriptor(((FieldInsnNode)insn).desc).getSize();
            default -> 1;
        }, insn);
    }

    @Override
    public SourceValue copyOperation(AbstractInsnNode insn, SourceValue value) {
        return new SourceValue(value.getSize(), insn);
    }

    @Override
    public SourceValue unaryOperation(AbstractInsnNode insn, SourceValue value) {
        int size = switch (insn.getOpcode()) {
            case 117, 119, 133, 135, 138, 140, 141, 143 -> 2;
            case 180 -> Type.fromDescriptor(((FieldInsnNode)insn).desc).getSize();
            default -> 1;
        };
        return new SourceValue(size, insn);
    }

    @Override
    public SourceValue binaryOperation(AbstractInsnNode insn, SourceValue value1, SourceValue value2) {
        int size = switch (insn.getOpcode()) {
            case 47, 49, 97, 99, 101, 103, 105, 107, 109, 111, 113, 115, 121, 123, 125, 127, 129, 131 -> 2;
            default -> 1;
        };
        return new SourceValue(size, insn);
    }

    @Override
    public SourceValue ternaryOperation(AbstractInsnNode insn, SourceValue value1, SourceValue value2, SourceValue value3) {
        return new SourceValue(1, insn);
    }

    @Override
    public SourceValue naryOperation(AbstractInsnNode insn, List<? extends SourceValue> values) {
        int opcode = insn.getOpcode();
        int size = opcode == 197 ? 1 : (opcode == 186 ? Type.forReturnType(((InvokeDynamicInsnNode)insn).desc).getSize() : Type.forReturnType(((MethodInsnNode)insn).desc).getSize());
        return new SourceValue(size, insn);
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, SourceValue value, SourceValue expected) {
    }

    @Override
    public SourceValue merge(SourceValue value1, SourceValue value2) {
        if (value1.insns instanceof SmallSet && value2.insns instanceof SmallSet) {
            Set<AbstractInsnNode> setUnion = ((SmallSet)value1.insns).union((SmallSet)value2.insns);
            if (setUnion == value1.insns && value1.size == value2.size) {
                return value1;
            }
            return new SourceValue(Math.min(value1.size, value2.size), setUnion);
        }
        if (value1.size != value2.size || !SourceInterpreter.containsAll(value1.insns, value2.insns)) {
            HashSet<AbstractInsnNode> setUnion = new HashSet<AbstractInsnNode>();
            setUnion.addAll(value1.insns);
            setUnion.addAll(value2.insns);
            return new SourceValue(Math.min(value1.size, value2.size), setUnion);
        }
        return value1;
    }

    private static <E> boolean containsAll(Set<E> self, Set<E> other) {
        if (self.size() < other.size()) {
            return false;
        }
        return self.containsAll(other);
    }
}

