/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.tree.analysis;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.tree.AbstractInsnNode;
import cn.taketoday.bytecode.tree.FieldInsnNode;
import cn.taketoday.bytecode.tree.InvokeDynamicInsnNode;
import cn.taketoday.bytecode.tree.MethodInsnNode;
import cn.taketoday.bytecode.tree.analysis.AnalyzerException;
import cn.taketoday.bytecode.tree.analysis.BasicInterpreter;
import cn.taketoday.bytecode.tree.analysis.BasicValue;
import java.util.List;

public class BasicVerifier
extends BasicInterpreter {
    @Override
    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        BasicValue expected;
        switch (insn.getOpcode()) {
            case 21: 
            case 54: {
                expected = BasicValue.INT_VALUE;
                break;
            }
            case 23: 
            case 56: {
                expected = BasicValue.FLOAT_VALUE;
                break;
            }
            case 22: 
            case 55: {
                expected = BasicValue.LONG_VALUE;
                break;
            }
            case 24: 
            case 57: {
                expected = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 25: {
                if (!value.isReference()) {
                    throw new AnalyzerException(insn, null, "an object reference", value);
                }
                return value;
            }
            case 58: {
                if (!value.isReference() && !BasicValue.RETURNADDRESS_VALUE.equals(value)) {
                    throw new AnalyzerException(insn, null, "an object reference or a return address", value);
                }
                return value;
            }
            default: {
                return value;
            }
        }
        if (!((Object)expected).equals(value)) {
            throw new AnalyzerException(insn, null, expected, value);
        }
        return value;
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        BasicValue expected;
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 145: 
            case 146: 
            case 147: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 188: 
            case 189: {
                expected = BasicValue.INT_VALUE;
                break;
            }
            case 118: 
            case 139: 
            case 140: 
            case 141: 
            case 174: {
                expected = BasicValue.FLOAT_VALUE;
                break;
            }
            case 117: 
            case 136: 
            case 137: 
            case 138: 
            case 173: {
                expected = BasicValue.LONG_VALUE;
                break;
            }
            case 119: 
            case 142: 
            case 143: 
            case 144: 
            case 175: {
                expected = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 180: {
                expected = this.newValue(Type.fromInternalName(((FieldInsnNode)insn).owner));
                break;
            }
            case 190: {
                if (!this.isArrayValue(value)) {
                    throw new AnalyzerException(insn, null, "an array reference", value);
                }
                return super.unaryOperation(insn, value);
            }
            case 176: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                if (!value.isReference()) {
                    throw new AnalyzerException(insn, null, "an object reference", value);
                }
                return super.unaryOperation(insn, value);
            }
            case 179: {
                expected = this.newValue(Type.fromDescriptor(((FieldInsnNode)insn).desc));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (!this.isSubTypeOf(value, expected)) {
            throw new AnalyzerException(insn, null, expected, value);
        }
        return super.unaryOperation(insn, value);
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        BasicValue expected1;
        BasicValue expected2 = switch (insn.getOpcode()) {
            case 46 -> {
                expected1 = this.newValue(Type.fromDescriptor("[I"));
                yield BasicValue.INT_VALUE;
            }
            case 51 -> {
                expected1 = this.isSubTypeOf(value1, this.newValue(Type.fromDescriptor("[Z"))) ? this.newValue(Type.fromDescriptor("[Z")) : this.newValue(Type.fromDescriptor("[B"));
                yield BasicValue.INT_VALUE;
            }
            case 52 -> {
                expected1 = this.newValue(Type.fromDescriptor("[C"));
                yield BasicValue.INT_VALUE;
            }
            case 53 -> {
                expected1 = this.newValue(Type.fromDescriptor("[S"));
                yield BasicValue.INT_VALUE;
            }
            case 47 -> {
                expected1 = this.newValue(Type.fromDescriptor("[J"));
                yield BasicValue.INT_VALUE;
            }
            case 48 -> {
                expected1 = this.newValue(Type.fromDescriptor("[F"));
                yield BasicValue.INT_VALUE;
            }
            case 49 -> {
                expected1 = this.newValue(Type.fromDescriptor("[D"));
                yield BasicValue.INT_VALUE;
            }
            case 50 -> {
                expected1 = this.newValue(Type.fromDescriptor("[Ljava/lang/Object;"));
                yield BasicValue.INT_VALUE;
            }
            case 96, 100, 104, 108, 112, 120, 122, 124, 126, 128, 130, 159, 160, 161, 162, 163, 164 -> {
                expected1 = BasicValue.INT_VALUE;
                yield BasicValue.INT_VALUE;
            }
            case 98, 102, 106, 110, 114, 149, 150 -> {
                expected1 = BasicValue.FLOAT_VALUE;
                yield BasicValue.FLOAT_VALUE;
            }
            case 97, 101, 105, 109, 113, 127, 129, 131, 148 -> {
                expected1 = BasicValue.LONG_VALUE;
                yield BasicValue.LONG_VALUE;
            }
            case 121, 123, 125 -> {
                expected1 = BasicValue.LONG_VALUE;
                yield BasicValue.INT_VALUE;
            }
            case 99, 103, 107, 111, 115, 151, 152 -> {
                expected1 = BasicValue.DOUBLE_VALUE;
                yield BasicValue.DOUBLE_VALUE;
            }
            case 165, 166 -> {
                expected1 = BasicValue.REFERENCE_VALUE;
                yield BasicValue.REFERENCE_VALUE;
            }
            case 181 -> {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                expected1 = this.newValue(Type.fromInternalName(fieldInsn.owner));
                yield this.newValue(Type.fromDescriptor(fieldInsn.desc));
            }
            default -> throw new AssertionError();
        };
        if (!this.isSubTypeOf(value1, expected1)) {
            throw new AnalyzerException(insn, "First argument", expected1, value1);
        }
        if (!this.isSubTypeOf(value2, expected2)) {
            throw new AnalyzerException(insn, "Second argument", expected2, value2);
        }
        if (insn.getOpcode() == 50) {
            return this.getElementValue(value1);
        }
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        BasicValue expected1;
        BasicValue expected3 = switch (insn.getOpcode()) {
            case 79 -> {
                expected1 = this.newValue(Type.fromDescriptor("[I"));
                yield BasicValue.INT_VALUE;
            }
            case 84 -> {
                expected1 = this.isSubTypeOf(value1, this.newValue(Type.fromDescriptor("[Z"))) ? this.newValue(Type.fromDescriptor("[Z")) : this.newValue(Type.fromDescriptor("[B"));
                yield BasicValue.INT_VALUE;
            }
            case 85 -> {
                expected1 = this.newValue(Type.fromDescriptor("[C"));
                yield BasicValue.INT_VALUE;
            }
            case 86 -> {
                expected1 = this.newValue(Type.fromDescriptor("[S"));
                yield BasicValue.INT_VALUE;
            }
            case 80 -> {
                expected1 = this.newValue(Type.fromDescriptor("[J"));
                yield BasicValue.LONG_VALUE;
            }
            case 81 -> {
                expected1 = this.newValue(Type.fromDescriptor("[F"));
                yield BasicValue.FLOAT_VALUE;
            }
            case 82 -> {
                expected1 = this.newValue(Type.fromDescriptor("[D"));
                yield BasicValue.DOUBLE_VALUE;
            }
            case 83 -> {
                expected1 = value1;
                yield BasicValue.REFERENCE_VALUE;
            }
            default -> throw new AssertionError();
        };
        if (!this.isSubTypeOf(value1, expected1)) {
            throw new AnalyzerException(insn, "First argument", "a " + expected1 + " array reference", value1);
        }
        if (!BasicValue.INT_VALUE.equals(value2)) {
            throw new AnalyzerException(insn, "Second argument", BasicValue.INT_VALUE, value2);
        }
        if (!this.isSubTypeOf(value3, expected3)) {
            throw new AnalyzerException(insn, "Third argument", expected3, value3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            for (BasicValue basicValue : values) {
                if (BasicValue.INT_VALUE.equals(basicValue)) continue;
                throw new AnalyzerException(insn, null, BasicValue.INT_VALUE, basicValue);
            }
        } else {
            int i = 0;
            boolean bl = false;
            if (opcode != 184 && opcode != 186) {
                Type owner = Type.fromInternalName(((MethodInsnNode)insn).owner);
                if (!this.isSubTypeOf(values.get(i++), this.newValue(owner))) {
                    throw new AnalyzerException(insn, "Method owner", this.newValue(owner), values.get(0));
                }
            }
            String methodDescriptor = opcode == 186 ? ((InvokeDynamicInsnNode)insn).desc : ((MethodInsnNode)insn).desc;
            Type[] args = Type.getArgumentTypes(methodDescriptor);
            int size = values.size();
            while (i < size) {
                BasicValue actual;
                void var5_8;
                BasicValue expected = this.newValue(args[++var5_8]);
                if (this.isSubTypeOf(actual = values.get(i++), expected)) continue;
                throw new AnalyzerException(insn, "Argument " + (int)var5_8, expected, actual);
            }
        }
        return super.naryOperation(insn, (List)values);
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, BasicValue value, BasicValue expected) throws AnalyzerException {
        if (!this.isSubTypeOf(value, expected)) {
            throw new AnalyzerException(insn, "Incompatible return type", expected, value);
        }
    }

    protected boolean isArrayValue(BasicValue value) {
        return value.isReference();
    }

    protected BasicValue getElementValue(BasicValue objectArrayValue) throws AnalyzerException {
        return BasicValue.REFERENCE_VALUE;
    }

    protected boolean isSubTypeOf(BasicValue value, BasicValue expected) {
        return value.equals(expected);
    }
}

