/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.tree.analysis;

import cn.taketoday.bytecode.Opcodes;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.tree.AbstractInsnNode;
import cn.taketoday.bytecode.tree.IincInsnNode;
import cn.taketoday.bytecode.tree.InsnList;
import cn.taketoday.bytecode.tree.JumpInsnNode;
import cn.taketoday.bytecode.tree.LabelNode;
import cn.taketoday.bytecode.tree.LookupSwitchInsnNode;
import cn.taketoday.bytecode.tree.MethodNode;
import cn.taketoday.bytecode.tree.TableSwitchInsnNode;
import cn.taketoday.bytecode.tree.TryCatchBlockNode;
import cn.taketoday.bytecode.tree.VarInsnNode;
import cn.taketoday.bytecode.tree.analysis.AnalyzerException;
import cn.taketoday.bytecode.tree.analysis.Frame;
import cn.taketoday.bytecode.tree.analysis.Interpreter;
import cn.taketoday.bytecode.tree.analysis.Subroutine;
import cn.taketoday.bytecode.tree.analysis.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class Analyzer<V extends Value>
implements Opcodes {
    private final Interpreter<V> interpreter;
    private InsnList insnList;
    private int insnListSize;
    private List<TryCatchBlockNode>[] handlers;
    private Frame<V>[] frames;
    private Subroutine[] subroutines;
    private boolean[] inInstructionsToProcess;
    private int[] instructionsToProcess;
    private int numInstructionsToProcess;

    public Analyzer(Interpreter<V> interpreter) {
        this.interpreter = interpreter;
    }

    public Frame<V>[] analyze(String owner, MethodNode method) throws AnalyzerException {
        if ((method.access & 0x500) != 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        InsnList insnList = method.instructions;
        int insnListSize = insnList.size();
        Frame[] frames = new Frame[insnListSize];
        Subroutine[] subroutines = new Subroutine[insnListSize];
        List[] handlers = new List[insnListSize];
        this.inInstructionsToProcess = new boolean[insnListSize];
        this.instructionsToProcess = new int[insnListSize];
        this.numInstructionsToProcess = 0;
        this.insnListSize = insnListSize;
        this.subroutines = subroutines;
        this.insnList = insnList;
        this.handlers = handlers;
        this.frames = frames;
        List<TryCatchBlockNode> tryCatchBlocks = method.tryCatchBlocks;
        if (tryCatchBlocks != null) {
            for (TryCatchBlockNode tryCatchBlock : tryCatchBlocks) {
                int startIndex = insnList.indexOf(tryCatchBlock.start);
                int endIndex = insnList.indexOf(tryCatchBlock.end);
                for (int j = startIndex; j < endIndex; ++j) {
                    ArrayList<TryCatchBlockNode> insnHandlers = handlers[j];
                    if (insnHandlers == null) {
                        handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                    }
                    insnHandlers.add(tryCatchBlock);
                }
            }
        }
        Subroutine main = new Subroutine(null, method.maxLocals, null);
        ArrayList<AbstractInsnNode> jsrInsns = new ArrayList<AbstractInsnNode>();
        this.findSubroutine(0, main, jsrInsns);
        HashMap<LabelNode, Subroutine> jsrSubroutines = new HashMap<LabelNode, Subroutine>();
        while (!jsrInsns.isEmpty()) {
            JumpInsnNode jsrInsn = (JumpInsnNode)jsrInsns.remove(0);
            Subroutine subroutine = (Subroutine)jsrSubroutines.get(jsrInsn.label);
            if (subroutine == null) {
                subroutine = new Subroutine(jsrInsn.label, method.maxLocals, jsrInsn);
                jsrSubroutines.put(jsrInsn.label, subroutine);
                this.findSubroutine(insnList.indexOf(jsrInsn.label), subroutine, jsrInsns);
                continue;
            }
            subroutine.callers.add(jsrInsn);
        }
        for (int i = 0; i < insnListSize; ++i) {
            if (subroutines[i] == null || subroutines[i].start != null) continue;
            subroutines[i] = null;
        }
        Frame<V> currentFrame = this.computeInitialFrame(owner, method);
        this.merge(0, currentFrame, null);
        this.init(owner, method);
        while (this.numInstructionsToProcess > 0) {
            int insnIndex = this.instructionsToProcess[--this.numInstructionsToProcess];
            Frame oldFrame = frames[insnIndex];
            Subroutine subroutine = subroutines[insnIndex];
            this.inInstructionsToProcess[insnIndex] = false;
            AbstractInsnNode insnNode = null;
            try {
                List insnHandlers;
                insnNode = method.instructions.get(insnIndex);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.merge(insnIndex + 1, oldFrame, subroutine);
                    this.newControlFlowEdge(insnIndex, insnIndex + 1);
                } else {
                    currentFrame.init(oldFrame).execute(insnNode, this.interpreter);
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : new Subroutine(subroutine);
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode jumpInsn = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            currentFrame.initJumpTarget(insnOpcode, null);
                            this.merge(insnIndex + 1, currentFrame, subroutine);
                            this.newControlFlowEdge(insnIndex, insnIndex + 1);
                        }
                        int jumpInsnIndex = insnList.indexOf(jumpInsn.label);
                        currentFrame.initJumpTarget(insnOpcode, jumpInsn.label);
                        if (insnOpcode == 168) {
                            this.merge(jumpInsnIndex, currentFrame, new Subroutine(jumpInsn.label, method.maxLocals, jumpInsn));
                        } else {
                            this.merge(jumpInsnIndex, currentFrame, subroutine);
                        }
                        this.newControlFlowEdge(insnIndex, jumpInsnIndex);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)insnNode;
                        targetInsnIndex = insnList.indexOf(lookupSwitchInsn.dflt);
                        currentFrame.initJumpTarget(insnOpcode, lookupSwitchInsn.dflt);
                        this.merge(targetInsnIndex, currentFrame, subroutine);
                        this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        for (i = 0; i < lookupSwitchInsn.labels.size(); ++i) {
                            LabelNode label = lookupSwitchInsn.labels.get(i);
                            targetInsnIndex = insnList.indexOf(label);
                            currentFrame.initJumpTarget(insnOpcode, label);
                            this.merge(targetInsnIndex, currentFrame, subroutine);
                            this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)insnNode;
                        targetInsnIndex = insnList.indexOf(tableSwitchInsn.dflt);
                        currentFrame.initJumpTarget(insnOpcode, tableSwitchInsn.dflt);
                        this.merge(targetInsnIndex, currentFrame, subroutine);
                        this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        for (i = 0; i < tableSwitchInsn.labels.size(); ++i) {
                            LabelNode label = tableSwitchInsn.labels.get(i);
                            currentFrame.initJumpTarget(insnOpcode, label);
                            targetInsnIndex = insnList.indexOf(label);
                            this.merge(targetInsnIndex, currentFrame, subroutine);
                            this.newControlFlowEdge(insnIndex, targetInsnIndex);
                        }
                    } else if (insnOpcode == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException(insnNode, "RET instruction outside of a subroutine");
                        }
                        for (int i = 0; i < subroutine.callers.size(); ++i) {
                            JumpInsnNode caller = subroutine.callers.get(i);
                            int jsrInsnIndex = insnList.indexOf(caller);
                            if (frames[jsrInsnIndex] == null) continue;
                            this.merge(jsrInsnIndex + 1, frames[jsrInsnIndex], currentFrame, subroutines[jsrInsnIndex], subroutine.localsUsed);
                            this.newControlFlowEdge(insnIndex, jsrInsnIndex + 1);
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        if (subroutine != null) {
                            if (insnNode instanceof VarInsnNode) {
                                var = ((VarInsnNode)insnNode).var;
                                subroutine.localsUsed[var] = true;
                                if (insnOpcode == 22 || insnOpcode == 24 || insnOpcode == 55 || insnOpcode == 57) {
                                    subroutine.localsUsed[var + 1] = true;
                                }
                            } else if (insnNode instanceof IincInsnNode) {
                                var = ((IincInsnNode)insnNode).var;
                                subroutine.localsUsed[var] = true;
                            }
                        }
                        this.merge(insnIndex + 1, currentFrame, subroutine);
                        this.newControlFlowEdge(insnIndex, insnIndex + 1);
                    }
                }
                if ((insnHandlers = handlers[insnIndex]) == null) continue;
                for (TryCatchBlockNode tryCatchBlock : insnHandlers) {
                    Type catchType = Type.fromInternalName(Objects.requireNonNullElse(tryCatchBlock.type, "java/lang/Throwable"));
                    if (!this.newControlFlowExceptionEdge(insnIndex, tryCatchBlock)) continue;
                    Frame<V> handler = this.newFrame(oldFrame);
                    handler.clearStack();
                    handler.push(this.interpreter.newExceptionValue(tryCatchBlock, handler, catchType));
                    this.merge(insnList.indexOf(tryCatchBlock.handler), handler, subroutine);
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insnIndex + ": " + e.getMessage(), e);
            }
            catch (RuntimeException e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insnIndex + ": " + e.getMessage(), e);
            }
        }
        return frames;
    }

    public Frame<V>[] analyzeAndComputeMaxs(String owner, MethodNode method) throws AnalyzerException {
        method.maxLocals = Analyzer.computeMaxLocals(method);
        method.maxStack = -1;
        this.analyze(owner, method);
        method.maxStack = Analyzer.computeMaxStack(this.frames);
        return this.frames;
    }

    private static int computeMaxLocals(MethodNode method) {
        int maxLocals = Type.getArgumentsAndReturnSizes(method.desc) >> 2;
        for (AbstractInsnNode insnNode : method.instructions) {
            int local;
            if (insnNode instanceof VarInsnNode) {
                VarInsnNode varInsnNode = (VarInsnNode)insnNode;
                local = varInsnNode.var;
                int size = insnNode.getOpcode() == 22 || insnNode.getOpcode() == 24 || insnNode.getOpcode() == 55 || insnNode.getOpcode() == 57 ? 2 : 1;
                maxLocals = Math.max(maxLocals, local + size);
                continue;
            }
            if (!(insnNode instanceof IincInsnNode)) continue;
            IincInsnNode iincInsnNode = (IincInsnNode)insnNode;
            local = iincInsnNode.var;
            maxLocals = Math.max(maxLocals, local + 1);
        }
        return maxLocals;
    }

    private static int computeMaxStack(Frame<?>[] frames) {
        int maxStack = 0;
        for (Frame<?> frame : frames) {
            if (frame == null) continue;
            int stackSize = 0;
            for (int i = 0; i < frame.getStackSize(); ++i) {
                stackSize += frame.getStack(i).getSize();
            }
            maxStack = Math.max(maxStack, stackSize);
        }
        return maxStack;
    }

    private void findSubroutine(int insnIndex, Subroutine subroutine, ArrayList<AbstractInsnNode> jsrInsns) throws AnalyzerException {
        ArrayList<Integer> instructionIndicesToProcess = new ArrayList<Integer>();
        instructionIndicesToProcess.add(insnIndex);
        InsnList insnList = this.insnList;
        Subroutine[] subroutines = this.subroutines;
        List<TryCatchBlockNode>[] handlers = this.handlers;
        block3: while (!instructionIndicesToProcess.isEmpty()) {
            int currentInsnIndex = (Integer)instructionIndicesToProcess.remove(instructionIndicesToProcess.size() - 1);
            if (currentInsnIndex < 0 || currentInsnIndex >= this.insnListSize) {
                throw new AnalyzerException(null, "Execution can fall off the end of the code");
            }
            if (subroutines[currentInsnIndex] != null) continue;
            subroutines[currentInsnIndex] = new Subroutine(subroutine);
            AbstractInsnNode currentInsn = insnList.get(currentInsnIndex);
            if (currentInsn instanceof JumpInsnNode) {
                if (currentInsn.getOpcode() == 168) {
                    jsrInsns.add(currentInsn);
                } else {
                    JumpInsnNode jumpInsn = (JumpInsnNode)currentInsn;
                    instructionIndicesToProcess.add(insnList.indexOf(jumpInsn.label));
                }
            } else if (currentInsn instanceof TableSwitchInsnNode) {
                TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)currentInsn;
                this.findSubroutine(insnList.indexOf(tableSwitchInsn.dflt), subroutine, jsrInsns);
                for (int i = tableSwitchInsn.labels.size() - 1; i >= 0; --i) {
                    labelNode = tableSwitchInsn.labels.get(i);
                    instructionIndicesToProcess.add(insnList.indexOf(labelNode));
                }
            } else if (currentInsn instanceof LookupSwitchInsnNode) {
                LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)currentInsn;
                this.findSubroutine(insnList.indexOf(lookupSwitchInsn.dflt), subroutine, jsrInsns);
                for (int i = lookupSwitchInsn.labels.size() - 1; i >= 0; --i) {
                    labelNode = lookupSwitchInsn.labels.get(i);
                    instructionIndicesToProcess.add(insnList.indexOf(labelNode));
                }
            }
            List<TryCatchBlockNode> insnHandlers = handlers[currentInsnIndex];
            if (insnHandlers != null) {
                for (TryCatchBlockNode tryCatchBlock : insnHandlers) {
                    instructionIndicesToProcess.add(insnList.indexOf(tryCatchBlock.handler));
                }
            }
            switch (currentInsn.getOpcode()) {
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    continue block3;
                }
            }
            instructionIndicesToProcess.add(currentInsnIndex + 1);
        }
    }

    private Frame<V> computeInitialFrame(String owner, MethodNode method) {
        Type[] argumentTypes;
        Frame<V> frame = this.newFrame(method.maxLocals, method.maxStack);
        int currentLocal = 0;
        boolean isInstanceMethod = (method.access & 8) == 0;
        Interpreter<V> interpreter = this.interpreter;
        if (isInstanceMethod) {
            Type ownerType = Type.fromInternalName(owner);
            frame.setLocal(currentLocal, interpreter.newParameterValue(isInstanceMethod, currentLocal, ownerType));
            ++currentLocal;
        }
        for (Type argumentType : argumentTypes = Type.getArgumentTypes(method.desc)) {
            frame.setLocal(currentLocal, interpreter.newParameterValue(isInstanceMethod, currentLocal, argumentType));
            ++currentLocal;
            if (argumentType.getSize() != 2) continue;
            frame.setLocal(currentLocal, interpreter.newEmptyValue(currentLocal));
            ++currentLocal;
        }
        while (currentLocal < method.maxLocals) {
            frame.setLocal(currentLocal, interpreter.newEmptyValue(currentLocal));
            ++currentLocal;
        }
        frame.setReturn(interpreter.newReturnTypeValue(Type.forReturnType(method.desc)));
        return frame;
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    public List<TryCatchBlockNode> getHandlers(int insnIndex) {
        return this.handlers[insnIndex];
    }

    protected void init(String owner, MethodNode method) throws AnalyzerException {
    }

    protected Frame<V> newFrame(int numLocals, int numStack) {
        return new Frame(numLocals, numStack);
    }

    protected Frame<V> newFrame(Frame<? extends V> frame) {
        return new Frame<V>(frame);
    }

    protected void newControlFlowEdge(int insnIndex, int successorIndex) {
    }

    protected boolean newControlFlowExceptionEdge(int insnIndex, int successorIndex) {
        return true;
    }

    protected boolean newControlFlowExceptionEdge(int insnIndex, TryCatchBlockNode tryCatchBlock) {
        return this.newControlFlowExceptionEdge(insnIndex, this.insnList.indexOf(tryCatchBlock.handler));
    }

    private void merge(int insnIndex, Frame<V> frame, Subroutine subroutine) throws AnalyzerException {
        boolean changed;
        Frame<V> oldFrame = this.frames[insnIndex];
        if (oldFrame == null) {
            this.frames[insnIndex] = this.newFrame(frame);
            changed = true;
        } else {
            changed = oldFrame.merge(frame, this.interpreter);
        }
        Subroutine oldSubroutine = this.subroutines[insnIndex];
        if (oldSubroutine == null) {
            if (subroutine != null) {
                this.subroutines[insnIndex] = new Subroutine(subroutine);
                changed = true;
            }
        } else if (subroutine != null) {
            changed |= oldSubroutine.merge(subroutine);
        }
        if (changed && !this.inInstructionsToProcess[insnIndex]) {
            this.inInstructionsToProcess[insnIndex] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = insnIndex;
        }
    }

    private void merge(int insnIndex, Frame<V> frameBeforeJsr, Frame<V> frameAfterRet, Subroutine subroutineBeforeJsr, boolean[] localsUsed) throws AnalyzerException {
        boolean changed;
        frameAfterRet.merge(frameBeforeJsr, localsUsed);
        Frame<V> oldFrame = this.frames[insnIndex];
        if (oldFrame == null) {
            this.frames[insnIndex] = this.newFrame(frameAfterRet);
            changed = true;
        } else {
            changed = oldFrame.merge(frameAfterRet, this.interpreter);
        }
        Subroutine oldSubroutine = this.subroutines[insnIndex];
        if (oldSubroutine != null && subroutineBeforeJsr != null) {
            changed |= oldSubroutine.merge(subroutineBeforeJsr);
        }
        if (changed && !this.inInstructionsToProcess[insnIndex]) {
            this.inInstructionsToProcess[insnIndex] = true;
            this.instructionsToProcess[this.numInstructionsToProcess++] = insnIndex;
        }
    }
}

