/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.tree;

import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.tree.LabelNode;
import cn.taketoday.bytecode.tree.TypeAnnotationNode;
import cn.taketoday.lang.Nullable;
import java.util.List;

public class TryCatchBlockNode {
    public LabelNode start;
    public LabelNode end;
    public LabelNode handler;
    public String type;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;

    public TryCatchBlockNode(LabelNode start, LabelNode end, LabelNode handler, String type) {
        this.start = start;
        this.end = end;
        this.handler = handler;
        this.type = type;
    }

    public void updateIndex(int index) {
        int newTypeRef = 0x42000000 | index << 8;
        if (this.visibleTypeAnnotations != null) {
            for (TypeAnnotationNode visibleTypeAnnotation : this.visibleTypeAnnotations) {
                visibleTypeAnnotation.typeRef = newTypeRef;
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            for (TypeAnnotationNode invisibleTypeAnnotation : this.invisibleTypeAnnotations) {
                invisibleTypeAnnotation.typeRef = newTypeRef;
            }
        }
    }

    public void accept(MethodVisitor methodVisitor) {
        methodVisitor.visitTryCatchBlock(this.start.getLabel(), this.end.getLabel(), this.handler == null ? null : this.handler.getLabel(), this.type);
        TryCatchBlockNode.doAccept(methodVisitor, this.visibleTypeAnnotations, true);
        TryCatchBlockNode.doAccept(methodVisitor, this.invisibleTypeAnnotations, false);
    }

    private static void doAccept(MethodVisitor methodVisitor, @Nullable List<TypeAnnotationNode> typeAnnotations, boolean visible) {
        if (typeAnnotations != null) {
            for (TypeAnnotationNode typeAnnotation : typeAnnotations) {
                typeAnnotation.accept(methodVisitor.visitTryCatchAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, visible));
            }
        }
    }
}

