/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.transform.impl;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.transform.ClassEmitterTransformer;
import java.lang.reflect.Modifier;
import java.util.Map;

public class AddPropertyTransformer
extends ClassEmitterTransformer {
    private final String[] names;
    private final Type[] types;

    public AddPropertyTransformer(Map<String, Type> props) {
        int size = props.size();
        this.names = props.keySet().toArray(new String[size]);
        this.types = new Type[size];
        for (int i = 0; i < size; ++i) {
            this.types[i] = props.get(this.names[i]);
        }
    }

    public AddPropertyTransformer(String[] names, Type[] types) {
        this.names = names;
        this.types = types;
    }

    @Override
    public void endClass() {
        if (!Modifier.isAbstract(this.getAccess())) {
            EmitUtils.addProperties(this, this.names, this.types);
        }
        super.endClass();
    }
}

