/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.transform.impl;

import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.transform.ClassEmitterTransformer;
import java.lang.reflect.Method;

public class AddInitTransformer
extends ClassEmitterTransformer {
    private final MethodInfo info;

    public AddInitTransformer(Method method) {
        this.info = MethodInfo.from(method);
        Type[] types = this.info.getSignature().getArgumentTypes();
        if (types.length != 1 || !types[0].equals(Type.TYPE_OBJECT) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(method + " illegal signature");
        }
    }

    @Override
    public CodeEmitter beginMethod(int access, MethodSignature sig, Type ... exceptions) {
        CodeEmitter emitter = super.beginMethod(access, sig, exceptions);
        if (sig.getName().equals("<init>")) {
            return new CodeEmitter(emitter){

                @Override
                public void visitInsn(int opcode) {
                    if (opcode == 177) {
                        this.loadThis();
                        this.invoke(AddInitTransformer.this.info);
                    }
                    super.visitInsn(opcode);
                }
            };
        }
        return emitter;
    }
}

