/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.reflect;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.commons.TableSwitchGenerator;
import cn.taketoday.bytecode.core.Block;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.DuplicatesPredicate;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.core.MethodInfoTransformer;
import cn.taketoday.bytecode.core.ObjectSwitchCallback;
import cn.taketoday.bytecode.core.VisibilityPredicate;
import cn.taketoday.bytecode.reflect.MethodAccess;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

final class MethodAccessEmitter
extends ClassEmitter {
    static final MethodSignature CSTRUCT_CLASS = MethodSignature.forConstructor("Class");
    static final MethodSignature METHOD_GET_INDEX = MethodSignature.from("int getIndex(String, Class[])");
    static final MethodSignature SIGNATURE_GET_INDEX = new MethodSignature(Type.INT_TYPE, "getIndex", Type.TYPE_SIGNATURE);
    static final MethodSignature CONSTRUCTOR_GET_INDEX = MethodSignature.from("int getIndex(Class[])");
    static final MethodSignature INVOKE = MethodSignature.from("Object invoke(int, Object, Object[])");
    static final MethodSignature NEW_INSTANCE = MethodSignature.from("Object newInstance(int, Object[])");
    static final MethodSignature GET_MAX_INDEX = MethodSignature.from("int getMaxIndex()");
    static final MethodSignature GET_SIGNATURE_WITHOUT_RETURN_TYPE = MethodSignature.from("String getSignatureWithoutReturnType(String, Class[])");
    private static final Type FAST_CLASS = Type.fromClass(MethodAccess.class);
    private static final Type ILLEGAL_ARGUMENT_EXCEPTION = Type.fromInternalName("java/lang/IllegalArgumentException");
    private static final Type INVOCATION_TARGET_EXCEPTION = Type.fromInternalName("java/lang/reflect/InvocationTargetException");
    private static final int TOO_MANY_METHODS = 100;

    public MethodAccessEmitter(ClassVisitor v, String className, Class type) {
        super(v);
        Type base = Type.fromClass(type);
        this.beginClass(52, 1, className, FAST_CLASS, null, "<cglibGenerated>");
        CodeEmitter e = this.beginMethod(1, CSTRUCT_CLASS, new Type[0]);
        e.loadThis();
        e.loadArgs();
        e.super_invoke_constructor(CSTRUCT_CLASS);
        e.returnValue();
        e.end_method();
        VisibilityPredicate vp = new VisibilityPredicate(type, false);
        List<Method> methods = MethodInfo.addAllMethods(type, new ArrayList<Method>());
        CollectionUtils.filter(methods, vp);
        CollectionUtils.filter(methods, new DuplicatesPredicate());
        Constructor<?>[] declaredConstructors = type.getDeclaredConstructors();
        ArrayList constructors = new ArrayList(declaredConstructors.length);
        Collections.addAll(constructors, declaredConstructors);
        CollectionUtils.filter(constructors, vp);
        this.emitIndexBySignature(methods);
        this.emitIndexByClassArray(methods);
        e = this.beginMethod(1, CONSTRUCTOR_GET_INDEX, new Type[0]);
        e.loadArgs();
        List<MethodInfo> info = CollectionUtils.transform(constructors, MethodInfoTransformer.getInstance());
        EmitUtils.constructorSwitch(e, info, new GetIndexCallback(e, info));
        e.end_method();
        e = this.beginMethod(1, INVOKE, INVOCATION_TARGET_EXCEPTION);
        e.loadArg(1);
        e.checkCast(base);
        e.loadArg(0);
        MethodAccessEmitter.invokeSwitchHelper(e, methods, 2, base);
        e.end_method();
        e = this.beginMethod(1, NEW_INSTANCE, INVOCATION_TARGET_EXCEPTION);
        e.newInstance(base);
        e.dup();
        e.loadArg(0);
        MethodAccessEmitter.invokeSwitchHelper(e, constructors, 1, base);
        e.end_method();
        e = this.beginMethod(1, GET_MAX_INDEX, new Type[0]);
        e.push(methods.size() - 1);
        e.returnValue();
        e.end_method();
        this.endClass();
    }

    private void emitIndexBySignature(List<Method> methods) {
        CodeEmitter e = this.beginMethod(1, SIGNATURE_GET_INDEX, new Type[0]);
        List<String> signatures = CollectionUtils.transform(methods, new Function<Method, String>(){

            @Override
            public String apply(Method obj) {
                return MethodSignature.from(obj).toString();
            }
        });
        e.loadArg(0);
        e.invokeVirtual(Type.TYPE_OBJECT, MethodSignature.TO_STRING);
        this.signatureSwitchHelper(e, signatures);
        e.end_method();
    }

    private void emitIndexByClassArray(List<Method> methods) {
        CodeEmitter e = this.beginMethod(1, METHOD_GET_INDEX, new Type[0]);
        if (methods.size() > 100) {
            List<String> signatures = CollectionUtils.transform(methods, new Function<Method, String>(){

                @Override
                public String apply(Method obj) {
                    String s = MethodSignature.from(obj).toString();
                    return s.substring(0, s.lastIndexOf(41) + 1);
                }
            });
            e.loadArgs();
            e.invokeStatic(FAST_CLASS, GET_SIGNATURE_WITHOUT_RETURN_TYPE);
            this.signatureSwitchHelper(e, signatures);
        } else {
            e.loadArgs();
            List<MethodInfo> info = CollectionUtils.transform(methods, MethodInfoTransformer.getInstance());
            EmitUtils.methodSwitch(e, info, new GetIndexCallback(e, info));
        }
        e.end_method();
    }

    private void signatureSwitchHelper(final CodeEmitter e, final List<String> signatures) {
        ObjectSwitchCallback callback = new ObjectSwitchCallback(){

            @Override
            public void processCase(Object key, Label end) {
                e.push(signatures.indexOf(key));
                e.returnValue();
            }

            @Override
            public void processDefault() {
                e.push(-1);
                e.returnValue();
            }
        };
        String[] strings = StringUtils.toStringArray(signatures);
        EmitUtils.stringSwitch(e, strings, 1, callback);
    }

    private static void invokeSwitchHelper(final CodeEmitter e, List members, final int arg, final Type base) {
        final List<MethodInfo> info = CollectionUtils.transform(members, MethodInfoTransformer.getInstance());
        final Label illegalArg = e.newLabel();
        Block block = e.begin_block();
        e.tableSwitch(MethodAccessEmitter.getIntRange(info.size()), new TableSwitchGenerator(){

            @Override
            public void generateCase(int key, Label end) {
                MethodInfo method = (MethodInfo)info.get(key);
                Type[] types = method.getSignature().getArgumentTypes();
                for (int i = 0; i < types.length; ++i) {
                    e.loadArg(arg);
                    e.aaload(i);
                    e.unbox(types[i]);
                }
                e.invoke(method, base);
                if (!method.isConstructor()) {
                    e.box(method.getSignature().getReturnType());
                }
                e.returnValue();
            }

            @Override
            public void generateDefault() {
                e.goTo(illegalArg);
            }
        });
        block.end();
        EmitUtils.wrapThrowable(block, INVOCATION_TARGET_EXCEPTION);
        e.mark(illegalArg);
        e.throwException(ILLEGAL_ARGUMENT_EXCEPTION, "Cannot find matching method/constructor");
    }

    private static int[] getIntRange(int length) {
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = i;
        }
        return range;
    }

    private static final class GetIndexCallback
    implements ObjectSwitchCallback {
        private final CodeEmitter codeEmitter;
        private final HashMap<Object, Integer> indexes = new HashMap();

        public GetIndexCallback(CodeEmitter e, List methods) {
            this.codeEmitter = e;
            int index = 0;
            for (Object object : methods) {
                this.indexes.put(object, index++);
            }
        }

        @Override
        public void processCase(Object key, Label end) {
            this.codeEmitter.push(this.indexes.get(key));
            this.codeEmitter.returnValue();
        }

        @Override
        public void processDefault() {
            this.codeEmitter.push(-1);
            this.codeEmitter.returnValue();
        }
    }
}

