/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.core.CodeGenerationException;
import cn.taketoday.bytecode.proxy.Callback;
import cn.taketoday.bytecode.proxy.CallbackFilter;
import cn.taketoday.bytecode.proxy.Enhancer;
import cn.taketoday.bytecode.proxy.InvocationHandler;
import cn.taketoday.bytecode.proxy.NoOp;
import java.io.Serializable;
import java.util.Objects;

public class Proxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final InvocationHandler h;
    private static final CallbackFilter BAD_OBJECT_METHOD_FILTER = method -> {
        String name;
        if ("java.lang.Object".equals(method.getDeclaringClass().getName()) && !(name = method.getName()).equals("hashCode") && !name.equals("equals") && !name.equals("toString")) {
            return 1;
        }
        return 0;
    };

    protected Proxy(InvocationHandler h) {
        this.h = h;
        Enhancer.registerCallbacks(this.getClass(), new Callback[]{h, null});
    }

    public static InvocationHandler getInvocationHandler(Object proxy) {
        if (proxy instanceof ProxyImpl) {
            return ((Proxy)proxy).h;
        }
        throw new IllegalArgumentException("Object is not a proxy");
    }

    public static Class<?> getProxyClass(ClassLoader loader, Class<?> ... interfaces) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(loader);
        enhancer.setUseFactory(false);
        enhancer.setInterfaces(interfaces);
        enhancer.setSuperclass(ProxyImpl.class);
        enhancer.setCallbackTypes(InvocationHandler.class, NoOp.class);
        enhancer.setCallbackFilter(BAD_OBJECT_METHOD_FILTER);
        return enhancer.createClass();
    }

    public static boolean isProxyClass(Class<?> cl) {
        return cl.getSuperclass().equals(ProxyImpl.class);
    }

    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, InvocationHandler h) {
        try {
            return Proxy.getProxyClass(loader, interfaces).getConstructor(InvocationHandler.class).newInstance(Objects.requireNonNull(h));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    private static class ProxyImpl
    extends Proxy {
        private static final long serialVersionUID = 1L;

        protected ProxyImpl(InvocationHandler h) {
            super(h);
        }
    }
}

