/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.core.RejectModifierPredicate;
import cn.taketoday.bytecode.proxy.MixinEmitter;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class MixinEverythingEmitter
extends MixinEmitter {
    public MixinEverythingEmitter(ClassVisitor v, String className, Class<?>[] classes) {
        super(v, className, classes, null);
    }

    @Override
    protected Class<?>[] getInterfaces(Class<?>[] classes) {
        HashSet list = new HashSet();
        for (Class<?> class1 : classes) {
            Set<Class<?>> allInterfacesForClass = ClassUtils.getAllInterfacesForClassAsSet(class1);
            CollectionUtils.addAll(list, allInterfacesForClass);
        }
        return ClassUtils.toClassArray(list);
    }

    @Override
    protected Method[] getMethods(Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Collections.addAll(methods, type.getMethods());
        CollectionUtils.filter(methods, new RejectModifierPredicate(24));
        return ReflectionUtils.toMethodArray(methods);
    }
}

