/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.core.MethodWrapper;
import cn.taketoday.bytecode.proxy.Mixin;
import java.lang.reflect.Method;
import java.util.HashSet;

class MixinEmitter
extends ClassEmitter {
    private static final String FIELD_NAME = "today$Delegates";
    private static final Type MIXIN = Type.fromClass(Mixin.class);
    private static final MethodSignature CSTRUCT_OBJECT_ARRAY = MethodSignature.forConstructor("Object[]");
    private static final MethodSignature NEW_INSTANCE = new MethodSignature(MIXIN, "newInstance", Type.TYPE_OBJECT_ARRAY);

    public MixinEmitter(ClassVisitor v, String className, Class<?>[] classes, int[] route) {
        super(v);
        this.beginClass(52, 1, className, MIXIN, Type.getTypes(this.getInterfaces(classes)), "<cglibGenerated>");
        EmitUtils.nullConstructor(this);
        EmitUtils.factoryMethod(this, NEW_INSTANCE);
        this.declare_field(2, FIELD_NAME, Type.TYPE_OBJECT_ARRAY, null);
        CodeEmitter e = this.beginMethod(1, CSTRUCT_OBJECT_ARRAY, new Type[0]);
        e.loadThis();
        e.super_invoke_constructor();
        e.loadThis();
        e.loadArg(0);
        e.putField(FIELD_NAME);
        e.returnValue();
        e.end_method();
        HashSet<Object> unique = new HashSet<Object>();
        int accVarargs = 128;
        for (int i = 0; i < classes.length; ++i) {
            Method[] methods;
            for (Method method : methods = this.getMethods(classes[i])) {
                if (!unique.add(MethodWrapper.create(method))) continue;
                MethodInfo methodInfo = MethodInfo.from(method);
                int modifiers = 1;
                if ((methodInfo.getModifiers() & 0x80) == 128) {
                    modifiers |= 0x80;
                }
                e = EmitUtils.beginMethod(this, methodInfo, modifiers);
                e.loadThis();
                e.getField(FIELD_NAME);
                e.aaload(route != null ? route[i] : i);
                e.checkCast(methodInfo.getClassInfo().getType());
                e.loadArgs();
                e.invoke(methodInfo);
                e.returnValue();
                e.end_method();
            }
        }
        this.endClass();
    }

    protected Class<?>[] getInterfaces(Class<?>[] classes) {
        return classes;
    }

    protected Method[] getMethods(Class<?> type) {
        return type.getMethods();
    }
}

