/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.CglibReflectUtils;
import cn.taketoday.bytecode.core.ClassesKey;
import cn.taketoday.bytecode.proxy.MixinBeanEmitter;
import cn.taketoday.bytecode.proxy.MixinEmitter;
import cn.taketoday.bytecode.proxy.MixinEverythingEmitter;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ReflectionUtils;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Mixin {
    private static final Map<Object, Route> ROUTE_CACHE = Collections.synchronizedMap(new HashMap());
    public static final int STYLE_INTERFACES = 0;
    public static final int STYLE_BEANS = 1;
    public static final int STYLE_EVERYTHING = 2;

    public abstract Mixin newInstance(Object[] var1);

    public static Mixin create(Object[] delegates) {
        Generator gen = new Generator();
        gen.setDelegates(delegates);
        return gen.create();
    }

    public static Mixin create(Class[] interfaces, Object[] delegates) {
        Generator gen = new Generator();
        gen.setClasses(interfaces);
        gen.setDelegates(delegates);
        return gen.create();
    }

    public static Mixin createBean(Object[] beans) {
        return Mixin.createBean(null, beans);
    }

    public static Mixin createBean(ClassLoader loader, Object[] beans) {
        Generator gen = new Generator();
        gen.setStyle(1);
        gen.setDelegates(beans);
        gen.setClassLoader(loader);
        return gen.create();
    }

    public static Class[] getClasses(Object[] delegates) {
        return (Class[])Mixin.route((Object[])delegates).classes.clone();
    }

    private static Route route(Object[] delegates) {
        Object key = ClassesKey.create(delegates);
        Route route = ROUTE_CACHE.get(key);
        if (route == null) {
            route = new Route(delegates);
            ROUTE_CACHE.put(key, route);
        }
        return route;
    }

    public static class Generator
    extends AbstractClassGenerator {
        private Class[] classes;
        private Object[] delegates;
        private int style = 0;
        private int[] route;

        public Generator() {
            super(Mixin.class);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.classes[0].getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectionUtils.getProtectionDomain(this.classes[0]);
        }

        public void setStyle(int style) {
            switch (style) {
                case 0: 
                case 1: 
                case 2: {
                    this.style = style;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mixin style: " + style);
                }
            }
        }

        public void setClasses(Class[] classes) {
            this.classes = classes;
        }

        public void setDelegates(Object[] delegates) {
            this.delegates = delegates;
        }

        public Mixin create() {
            Class[] classes = this.classes;
            Object[] delegates = this.delegates;
            if (classes == null && delegates == null) {
                throw new IllegalStateException("Either classes or delegates must be set");
            }
            switch (this.style) {
                case 0: {
                    if (classes != null) break;
                    Route r = Mixin.route(delegates);
                    classes = r.classes;
                    this.classes = classes;
                    this.route = r.route;
                    break;
                }
                default: {
                    if (classes == null) {
                        classes = CglibReflectUtils.getClasses(delegates);
                        this.classes = classes;
                        break;
                    }
                    if (delegates == null) break;
                    if (classes.length != delegates.length) {
                        throw new IllegalStateException("Specified classes are incompatible with delegates");
                    }
                    for (int i = 0; i < classes.length; ++i) {
                        if (classes[i].isInstance(delegates[i])) continue;
                        throw new IllegalStateException("Specified class " + classes[i] + " is incompatible with delegate class " + delegates[i].getClass() + " (index " + i + ")");
                    }
                }
            }
            this.setNamePrefix(classes[CglibReflectUtils.findPackageProtected(classes)].getName());
            return (Mixin)super.create(new MixinKey(this.style, Arrays.asList(CglibReflectUtils.getNames(classes)), this.route));
        }

        @Override
        public void generateClass(ClassVisitor v) {
            switch (this.style) {
                case 0: {
                    new MixinEmitter(v, this.getClassName(), this.classes, this.route);
                    break;
                }
                case 1: {
                    new MixinBeanEmitter(v, this.getClassName(), this.classes);
                    break;
                }
                case 2: {
                    new MixinEverythingEmitter(v, this.getClassName(), this.classes);
                }
            }
        }

        protected Object firstInstance(Class type) {
            return ((Mixin)ReflectionUtils.newInstance(type)).newInstance(this.delegates);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((Mixin)instance).newInstance(this.delegates);
        }
    }

    private static final class Route {
        private final int[] route;
        private final Class<?>[] classes;

        Route(Object[] delegates) {
            HashMap<Class, Integer> map = new HashMap<Class, Integer>();
            for (int i = 0; i < delegates.length; ++i) {
                Class<?> delegate = delegates[i].getClass();
                Set<Class<?>> allInterfacesForClass = ClassUtils.getAllInterfacesForClassAsSet(delegate);
                for (Class clazz : allInterfacesForClass) {
                    if (map.containsKey(clazz)) continue;
                    map.put(clazz, i);
                }
            }
            int index = 0;
            int[] route = new int[map.size()];
            Class[] classes = new Class[map.size()];
            for (Map.Entry entry : map.entrySet()) {
                Class key;
                classes[index] = key = (Class)entry.getKey();
                route[index++] = (Integer)entry.getValue();
            }
            this.route = route;
            this.classes = classes;
        }
    }

    record MixinKey(int style, List<String> classes, int[] route) {
    }
}

