/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.proxy;

import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.bytecode.proxy.CallbackGenerator;
import cn.taketoday.bytecode.proxy.LazyLoader;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

final class LazyLoaderGenerator
implements CallbackGenerator {
    public static final LazyLoaderGenerator INSTANCE = new LazyLoaderGenerator();
    private static final MethodSignature LOAD_OBJECT = MethodSignature.from("Object loadObject()");
    private static final Type LAZY_LOADER = Type.fromClass(LazyLoader.class);

    LazyLoaderGenerator() {
    }

    @Override
    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List<MethodInfo> methods) {
        CodeEmitter e;
        HashSet<Integer> indexes = new HashSet<Integer>();
        for (MethodInfo method : methods) {
            if (Modifier.isProtected(method.getModifiers())) continue;
            int index = context.getIndex(method);
            indexes.add(index);
            e = context.beginMethod(ce, method);
            e.loadThis();
            e.dup();
            e.invoke_virtual_this(this.loadMethod(index));
            e.checkCast(method.getClassInfo().getType());
            e.loadArgs();
            e.invoke(method);
            e.returnValue();
            e.end_method();
        }
        Iterator<MethodInfo> iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)((Object)iterator.next());
            String delegate = "today$LazyLoader" + index;
            ce.declare_field(2, delegate, Type.TYPE_OBJECT, null);
            e = ce.beginMethod(50, this.loadMethod(index), new Type[0]);
            e.loadThis();
            e.getField(delegate);
            e.dup();
            Label end = e.newLabel();
            e.ifNonNull(end);
            e.pop();
            e.loadThis();
            context.emitCallback(e, index);
            e.invokeInterface(LAZY_LOADER, LOAD_OBJECT);
            e.dupX1();
            e.putField(delegate);
            e.mark(end);
            e.returnValue();
            e.end_method();
        }
    }

    private MethodSignature loadMethod(int index) {
        return new MethodSignature(Type.TYPE_OBJECT, "today$LoadPrivate" + index, Type.EMPTY_ARRAY);
    }

    @Override
    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List<MethodInfo> methods) {
    }
}

