/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.commons.GeneratorAdapter;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.bytecode.core.CglibReflectUtils;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.Customizer;
import cn.taketoday.bytecode.core.CustomizerRegistry;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.FieldTypeCustomizer;
import cn.taketoday.bytecode.core.HashCodeCustomizer;
import cn.taketoday.bytecode.core.KeyFactoryCustomizer;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.List;

public abstract class KeyFactory {
    private static final Type KEY_FACTORY = Type.fromClass(KeyFactory.class);
    private static final MethodSignature GET_SORT = MethodSignature.from("int getSort()");
    private static final MethodSignature GET_NAME = MethodSignature.from("String getName()");
    private static final MethodSignature APPEND_STRING = MethodSignature.from("StringBuffer append(String)");
    private static final int[] PRIMES = new int[]{11, 73, 179, 331, 521, 787, 1213, 1823, 2609, 3691, 5189, 7247, 10037, 13931, 19289, 26627, 36683, 50441, 69403, 95401, 131129, 180179, 247501, 340057, 467063, 641371, 880603, 1209107, 1660097, 2279161, 3129011, 4295723, 5897291, 8095873, 11114263, 15257791, 20946017, 28754629, 39474179, 54189869, 74391461, 102123817, 140194277, 192456917, 264202273, 362693231, 497900099, 683510293, 938313161, 1288102441, 1768288259};
    public static final Customizer CLASS_BY_NAME = (e, type) -> {
        if (type.equals(Type.TYPE_CLASS)) {
            e.invokeVirtual(Type.TYPE_CLASS, GET_NAME);
        }
    };
    public static final HashCodeCustomizer HASH_ASM_TYPE = (e, type) -> {
        if (Type.TYPE_TYPE.equals(type)) {
            e.invokeVirtual(type, GET_SORT);
            return true;
        }
        return false;
    };

    protected KeyFactory() {
    }

    public static <T> T create(Class<T> keyInterface) {
        return KeyFactory.create(keyInterface, null);
    }

    public static <T> T create(Class<T> keyInterface, Customizer customizer) {
        return KeyFactory.create(keyInterface.getClassLoader(), keyInterface, customizer);
    }

    public static <T> T create(Class<T> keyInterface, KeyFactoryCustomizer first, List<KeyFactoryCustomizer> next) {
        return KeyFactory.create(keyInterface.getClassLoader(), keyInterface, first, next);
    }

    public static <T> T create(ClassLoader loader, Class<T> keyInterface, Customizer customizer) {
        return KeyFactory.create(loader, keyInterface, customizer, Collections.emptyList());
    }

    public static <T> T create(ClassLoader loader, Class<T> keyInterface, KeyFactoryCustomizer customizer, List<KeyFactoryCustomizer> next) {
        Generator gen = new Generator();
        gen.setInterface(keyInterface);
        gen.setNeighbor(keyInterface);
        if (customizer != null) {
            gen.addCustomizer(customizer);
        }
        if (CollectionUtils.isNotEmpty(next)) {
            for (KeyFactoryCustomizer keyFactoryCustomizer : next) {
                gen.addCustomizer(keyFactoryCustomizer);
            }
        }
        gen.setClassLoader(loader);
        return (T)gen.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final Class[] KNOWN_CUSTOMIZER_TYPES = new Class[]{Customizer.class, FieldTypeCustomizer.class};
        private Class keyInterface;
        private final CustomizerRegistry customizers = new CustomizerRegistry(KNOWN_CUSTOMIZER_TYPES);
        private int constant;
        private int multiplier;

        public Generator() {
            super(KeyFactory.class);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.keyInterface.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectionUtils.getProtectionDomain(this.keyInterface);
        }

        public void addCustomizer(KeyFactoryCustomizer customizer) {
            this.customizers.add(customizer);
        }

        public <T> List<T> getCustomizers(Class<T> klass) {
            return this.customizers.get(klass);
        }

        public void setInterface(Class keyInterface) {
            this.keyInterface = keyInterface;
        }

        public KeyFactory create() {
            this.setNamePrefix(this.keyInterface.getName());
            return (KeyFactory)super.create(this.keyInterface.getName());
        }

        public void setHashConstant(int constant) {
            this.constant = constant;
        }

        public void setHashMultiplier(int multiplier) {
            this.multiplier = multiplier;
        }

        protected Object firstInstance(Class type) {
            return ReflectionUtils.newInstance(type);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return instance;
        }

        @Override
        public void generateClass(ClassVisitor v) {
            int i;
            ClassEmitter ce = new ClassEmitter(v);
            Method newInstance = CglibReflectUtils.findNewInstance(this.keyInterface);
            if (!newInstance.getReturnType().equals(Object.class)) {
                throw new IllegalArgumentException("newInstance method must return Object");
            }
            Type[] parameterTypes = Type.getTypes(newInstance.getParameterTypes());
            ce.beginClass(52, 1, this.getClassName(), KEY_FACTORY, Type.array(Type.fromClass(this.keyInterface)), "<cglibGenerated>");
            EmitUtils.nullConstructor(ce);
            EmitUtils.factoryMethod(ce, MethodSignature.from(newInstance));
            int seed = 0;
            CodeEmitter e = ce.beginMethod(1, MethodSignature.forConstructor(parameterTypes), new Type[0]);
            e.loadThis();
            e.super_invoke_constructor();
            e.loadThis();
            List<FieldTypeCustomizer> fieldTypeCustomizers = this.getCustomizers(FieldTypeCustomizer.class);
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                Type parameterType;
                Type fieldType = parameterType = parameterTypes[i2];
                for (FieldTypeCustomizer customizer : fieldTypeCustomizers) {
                    fieldType = customizer.getOutType(i2, fieldType);
                }
                seed += fieldType.hashCode();
                ce.declare_field(18, this.getFieldName(i2), fieldType, null);
                e.dup();
                e.loadArg(i2);
                for (FieldTypeCustomizer customizer : fieldTypeCustomizers) {
                    customizer.customize(e, i2, parameterType);
                }
                e.putField(this.getFieldName(i2));
            }
            e.returnValue();
            e.end_method();
            e = ce.beginMethod(1, MethodSignature.HASH_CODE, new Type[0]);
            int hc = this.constant != 0 ? this.constant : PRIMES[Math.abs(seed) % PRIMES.length];
            int hm = this.multiplier != 0 ? this.multiplier : PRIMES[Math.abs(seed * 13) % PRIMES.length];
            e.push(hc);
            for (int i3 = 0; i3 < parameterTypes.length; ++i3) {
                e.loadThis();
                e.getField(this.getFieldName(i3));
                EmitUtils.hashCode((GeneratorAdapter)e, parameterTypes[i3], hm, this.customizers);
            }
            e.returnValue();
            e.end_method();
            e = ce.beginMethod(1, MethodSignature.EQUALS, new Type[0]);
            Label fail = e.newLabel();
            e.loadArg(0);
            e.instance_of_this();
            e.ifJump(153, fail);
            for (i = 0; i < parameterTypes.length; ++i) {
                e.loadThis();
                e.getField(this.getFieldName(i));
                e.loadArg(0);
                e.checkcast_this();
                e.getField(this.getFieldName(i));
                EmitUtils.notEquals(e, parameterTypes[i], fail, this.customizers);
            }
            e.push(1);
            e.returnValue();
            e.mark(fail);
            e.push(0);
            e.returnValue();
            e.end_method();
            e = ce.beginMethod(1, MethodSignature.TO_STRING, new Type[0]);
            e.newInstance(Type.TYPE_STRING_BUFFER);
            e.dup();
            e.invokeConstructor(Type.TYPE_STRING_BUFFER);
            for (i = 0; i < parameterTypes.length; ++i) {
                if (i > 0) {
                    e.push(", ");
                    e.invokeVirtual(Type.TYPE_STRING_BUFFER, APPEND_STRING);
                }
                e.loadThis();
                e.getField(this.getFieldName(i));
                EmitUtils.appendString(e, parameterTypes[i], EmitUtils.DEFAULT_DELIMITERS, this.customizers);
            }
            e.invokeVirtual(Type.TYPE_STRING_BUFFER, MethodSignature.TO_STRING);
            e.returnValue();
            e.end_method();
            ce.endClass();
        }

        private String getFieldName(int arg) {
            return "today$field_" + arg;
        }
    }
}

