/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.core;

import cn.taketoday.bytecode.core.NamingPolicy;
import cn.taketoday.lang.TodayStrategies;
import java.util.function.Predicate;

public class DefaultNamingPolicy
implements NamingPolicy {
    public static final DefaultNamingPolicy INSTANCE = new DefaultNamingPolicy();
    private static final boolean STRESS_HASH_CODE = TodayStrategies.getFlag("bytecode.stressHashCodes");

    @Override
    public String getClassName(String prefix, String source, Object key, Predicate<String> names) {
        if (prefix == null) {
            prefix = "cn.taketoday.bytecode.Object";
        } else if (((String)prefix).startsWith("java")) {
            prefix = "system$" + (String)prefix;
        }
        String base = (String)prefix + "$$" + source + this.getTag() + "$$" + Integer.toHexString(STRESS_HASH_CODE ? 0 : key.hashCode());
        Object attempt = base;
        int index = 2;
        while (names.test((String)attempt)) {
            attempt = base + "_" + index++;
        }
        return attempt;
    }

    protected String getTag() {
        return "ByTODAY";
    }

    public int hashCode() {
        return this.getTag().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        DefaultNamingPolicy policy;
        return o instanceof DefaultNamingPolicy && (policy = (DefaultNamingPolicy)o).getTag().equals(this.getTag());
    }
}

