/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.commons;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.MethodVisitor;

public class StaticInitMerger
extends ClassVisitor {
    private String owner;
    private final String renamedClinitMethodPrefix;
    private int numClinitMethods;
    private MethodVisitor mergedClinitVisitor;

    public StaticInitMerger(String prefix, ClassVisitor classVisitor) {
        super(classVisitor);
        this.renamedClinitMethodPrefix = prefix;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.owner = name;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor methodVisitor;
        if ("<clinit>".equals(name)) {
            int newAccess = 10;
            String newName = this.renamedClinitMethodPrefix + this.numClinitMethods++;
            methodVisitor = super.visitMethod(newAccess, newName, descriptor, signature, exceptions);
            MethodVisitor mergedClinitVisitor = this.mergedClinitVisitor;
            if (mergedClinitVisitor == null) {
                this.mergedClinitVisitor = mergedClinitVisitor = super.visitMethod(newAccess, name, descriptor, null, null);
            }
            mergedClinitVisitor.visitMethodInsn(184, this.owner, newName, descriptor, false);
        } else {
            methodVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        return methodVisitor;
    }

    @Override
    public void visitEnd() {
        MethodVisitor mergedClinitVisitor = this.mergedClinitVisitor;
        if (mergedClinitVisitor != null) {
            mergedClinitVisitor.visitInsn(177);
            mergedClinitVisitor.visitMaxs(0, 0);
        }
        super.visitEnd();
    }
}

