/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.commons;

import cn.taketoday.bytecode.AnnotationVisitor;
import cn.taketoday.bytecode.Label;
import cn.taketoday.bytecode.MethodVisitor;
import cn.taketoday.bytecode.Opcodes;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.TypePath;
import cn.taketoday.bytecode.commons.Local;

public class LocalVariablesSorter
extends MethodVisitor {
    private int[] remappedVariableIndices = new int[40];
    private Object[] remappedLocalTypes = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;
    protected final Type[] argumentTypes;

    public LocalVariablesSorter(int access, String descriptor, MethodVisitor methodVisitor) {
        this(access, Type.getArgumentTypes(descriptor), methodVisitor);
    }

    public LocalVariablesSorter(int access, Type[] argumentTypes, MethodVisitor methodVisitor) {
        super(methodVisitor);
        int nextLocal = (8 & access) == 0 ? 1 : 0;
        for (Type argumentType : argumentTypes) {
            nextLocal += argumentType.getSize();
        }
        this.nextLocal = nextLocal;
        this.firstLocal = nextLocal;
        this.argumentTypes = argumentTypes;
    }

    public LocalVariablesSorter(LocalVariablesSorter lvs) {
        super(lvs.mv);
        this.nextLocal = lvs.nextLocal;
        this.firstLocal = lvs.firstLocal;
        this.argumentTypes = lvs.argumentTypes;
        this.remappedLocalTypes = lvs.remappedLocalTypes;
        this.remappedVariableIndices = lvs.remappedVariableIndices;
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        Type varType = switch (opcode) {
            case 22, 55 -> Type.LONG_TYPE;
            case 24, 57 -> Type.DOUBLE_TYPE;
            case 23, 56 -> Type.FLOAT_TYPE;
            case 21, 54 -> Type.INT_TYPE;
            case 25, 58, 169 -> Type.TYPE_OBJECT;
            default -> throw new IllegalArgumentException("Invalid opcode " + opcode);
        };
        super.visitVarInsn(opcode, this.remap(var, varType));
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(this.remap(var, Type.INT_TYPE), increment);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, this.nextLocal);
    }

    @Override
    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        int remappedIndex = this.remap(index);
        super.visitLocalVariable(name, descriptor, signature, start, end, remappedIndex);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        Type type = Type.fromDescriptor(descriptor);
        int[] remappedIndex = new int[index.length];
        for (int i = 0; i < remappedIndex.length; ++i) {
            remappedIndex[i] = this.remap(index[i], type);
        }
        return super.visitLocalVariableAnnotation(typeRef, typePath, start, end, remappedIndex, descriptor, visible);
    }

    @Override
    public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        Object localType;
        if (type != -1) {
            throw new IllegalArgumentException("LocalVariablesSorter only accepts expanded frames (see ClassReader.EXPAND_FRAMES)");
        }
        Object[] oldRemappedLocals = new Object[this.remappedLocalTypes.length];
        System.arraycopy(this.remappedLocalTypes, 0, oldRemappedLocals, 0, oldRemappedLocals.length);
        this.updateNewLocals(this.remappedLocalTypes);
        int oldVar = 0;
        for (int i = 0; i < numLocal; ++i) {
            Object localType2 = local[i];
            if (localType2 != Opcodes.TOP) {
                Type varType = localType2 == Opcodes.INTEGER ? Type.INT_TYPE : (localType2 == Opcodes.FLOAT ? Type.FLOAT_TYPE : (localType2 == Opcodes.LONG ? Type.LONG_TYPE : (localType2 == Opcodes.DOUBLE ? Type.DOUBLE_TYPE : (localType2 instanceof String ? Type.fromInternalName((String)localType2) : Type.TYPE_OBJECT))));
                this.setFrameLocal(this.remap(oldVar, varType), localType2);
            }
            oldVar += localType2 == Opcodes.LONG || localType2 == Opcodes.DOUBLE ? 2 : 1;
        }
        int newVar = 0;
        int remappedNumLocal = 0;
        for (oldVar = 0; oldVar < this.remappedLocalTypes.length; oldVar += (localType = this.remappedLocalTypes[oldVar]) == Opcodes.LONG || localType == Opcodes.DOUBLE ? 2 : 1) {
            if (localType != null && localType != Opcodes.TOP) {
                this.remappedLocalTypes[newVar++] = localType;
                remappedNumLocal = newVar;
                continue;
            }
            this.remappedLocalTypes[newVar++] = Opcodes.TOP;
        }
        super.visitFrame(type, remappedNumLocal, this.remappedLocalTypes, numStack, stack);
        this.remappedLocalTypes = oldRemappedLocals;
    }

    public Local newLocal() {
        return this.newLocal(Type.TYPE_OBJECT);
    }

    public Local newLocal(Type type) {
        return new Local(this.newLocalIndex(type), type);
    }

    public int newLocalIndex(Type type) {
        Object localType = switch (type.getSort()) {
            case 1, 2, 3, 4, 5 -> Opcodes.INTEGER;
            case 6 -> Opcodes.FLOAT;
            case 7 -> Opcodes.LONG;
            case 8 -> Opcodes.DOUBLE;
            case 9 -> type.getDescriptor();
            case 10 -> type.getInternalName();
            default -> throw new AssertionError();
        };
        int local = this.newLocalMapping(type);
        this.setLocalType(local, type);
        this.setFrameLocal(local, localType);
        return local;
    }

    protected void updateNewLocals(Object[] newLocals) {
    }

    protected void setLocalType(int local, Type type) {
    }

    private void setFrameLocal(int local, Object type) {
        int numLocals = this.remappedLocalTypes.length;
        if (local >= numLocals) {
            Object[] newRemappedLocalTypes = new Object[Math.max(2 * numLocals, local + 1)];
            System.arraycopy(this.remappedLocalTypes, 0, newRemappedLocalTypes, 0, numLocals);
            newRemappedLocalTypes[local] = type;
            this.remappedLocalTypes = newRemappedLocalTypes;
        } else {
            this.remappedLocalTypes[local] = type;
        }
    }

    private int remap(int var, Type type) {
        int value;
        int size;
        if (var + type.getSize() <= this.firstLocal) {
            return var;
        }
        int key = 2 * var + type.getSize() - 1;
        if (key >= (size = this.remappedVariableIndices.length)) {
            int[] newRemappedVariableIndices = new int[Math.max(2 * size, key + 1)];
            System.arraycopy(this.remappedVariableIndices, 0, newRemappedVariableIndices, 0, size);
            this.remappedVariableIndices = newRemappedVariableIndices;
        }
        if ((value = this.remappedVariableIndices[key]) == 0) {
            value = this.newLocalMapping(type);
            this.setLocalType(value, type);
            this.remappedVariableIndices[key] = value + 1;
        } else {
            --value;
        }
        return value;
    }

    private int remap(int var) {
        int value;
        if (var < this.firstLocal) {
            return var;
        }
        int key = 2 * var;
        int n = value = key < this.remappedVariableIndices.length ? this.remappedVariableIndices[key] : 0;
        if (value == 0) {
            int n2 = value = key + 1 < this.remappedVariableIndices.length ? this.remappedVariableIndices[key + 1] : 0;
        }
        if (value == 0) {
            throw new IllegalStateException("Unknown local variable " + var);
        }
        return value - 1;
    }

    protected int newLocalMapping(Type type) {
        int local = this.nextLocal;
        this.nextLocal += type.getSize();
        return local;
    }

    public Type[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public Type[] cloneArgumentTypes() {
        return (Type[])this.argumentTypes.clone();
    }
}

