/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.commons;

import cn.taketoday.bytecode.AnnotationVisitor;
import cn.taketoday.bytecode.commons.Remapper;

public class AnnotationRemapper
extends AnnotationVisitor {
    protected final String descriptor;
    protected final Remapper remapper;

    public AnnotationRemapper(String descriptor, AnnotationVisitor annotationVisitor, Remapper remapper) {
        super(annotationVisitor);
        this.descriptor = descriptor;
        this.remapper = remapper;
    }

    @Override
    public void visit(String name, Object value) {
        super.visit(this.mapAnnotationAttributeName(name), this.remapper.mapValue(value));
    }

    @Override
    public void visitEnum(String name, String descriptor, String value) {
        super.visitEnum(this.mapAnnotationAttributeName(name), this.remapper.mapDesc(descriptor), value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.mapAnnotationAttributeName(name), this.remapper.mapDesc(descriptor));
        if (annotationVisitor == null) {
            return null;
        }
        return annotationVisitor == this.av ? this : this.createAnnotationRemapper(descriptor, annotationVisitor);
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        AnnotationVisitor annotationVisitor = super.visitArray(this.mapAnnotationAttributeName(name));
        if (annotationVisitor == null) {
            return null;
        }
        return annotationVisitor == this.av ? this : this.createAnnotationRemapper(null, annotationVisitor);
    }

    protected AnnotationVisitor createAnnotationRemapper(String descriptor, AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(descriptor, annotationVisitor, this.remapper);
    }

    private String mapAnnotationAttributeName(String name) {
        if (this.descriptor == null) {
            return name;
        }
        return this.remapper.mapAnnotationAttributeName(this.descriptor, name);
    }
}

