/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.beans;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.Type;
import cn.taketoday.bytecode.beans.BulkBean;
import cn.taketoday.bytecode.beans.BulkBeanException;
import cn.taketoday.bytecode.commons.Local;
import cn.taketoday.bytecode.commons.MethodSignature;
import cn.taketoday.bytecode.core.Block;
import cn.taketoday.bytecode.core.ClassEmitter;
import cn.taketoday.bytecode.core.CodeEmitter;
import cn.taketoday.bytecode.core.EmitUtils;
import cn.taketoday.bytecode.core.MethodInfo;
import cn.taketoday.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class BulkBeanEmitter
extends ClassEmitter {
    private static final MethodSignature GET_PROPERTY_VALUES = MethodSignature.from("void getPropertyValues(Object, Object[])");
    private static final MethodSignature SET_PROPERTY_VALUES = MethodSignature.from("void setPropertyValues(Object, Object[])");
    private static final MethodSignature CSTRUCT_EXCEPTION = MethodSignature.forConstructor("Throwable, int");
    private static final Type BULK_BEAN = Type.fromClass(BulkBean.class);
    private static final Type BULK_BEAN_EXCEPTION = Type.fromClass(BulkBeanException.class);

    public BulkBeanEmitter(ClassVisitor v, String className, Class target, String[] getterNames, String[] setterNames, Class[] types) {
        super(v);
        Method[] getters = new Method[getterNames.length];
        Method[] setters = new Method[setterNames.length];
        BulkBeanEmitter.validate(target, getterNames, setterNames, types, getters, setters);
        this.beginClass(52, 1, className, BULK_BEAN, null, "<cglibGenerated>");
        EmitUtils.nullConstructor(this);
        this.generateGet(target, getters);
        this.generateSet(target, setters);
        this.endClass();
    }

    private void generateGet(Class target, Method[] getters) {
        CodeEmitter e = this.beginMethod(1, GET_PROPERTY_VALUES, new Type[0]);
        if (getters.length > 0) {
            e.loadArg(0);
            e.checkCast(Type.fromClass(target));
            Local bean = e.newLocal();
            e.storeLocal(bean);
            for (int i = 0; i < getters.length; ++i) {
                if (getters[i] == null) continue;
                MethodInfo getter = MethodInfo.from(getters[i]);
                e.loadArg(1);
                e.push(i);
                e.loadLocal(bean);
                e.invoke(getter);
                e.box(getter.getSignature().getReturnType());
                e.aastore();
            }
        }
        e.returnValue();
        e.end_method();
    }

    private void generateSet(Class target, Method[] setters) {
        CodeEmitter e = this.beginMethod(1, SET_PROPERTY_VALUES, new Type[0]);
        if (setters.length > 0) {
            Local index = e.newLocal(Type.INT_TYPE);
            e.push(0);
            e.storeLocal(index);
            e.loadArg(0);
            e.checkCast(Type.fromClass(target));
            e.loadArg(1);
            Block handler = e.begin_block();
            int lastIndex = 0;
            block4: for (int i = 0; i < setters.length; ++i) {
                if (setters[i] == null) continue;
                MethodInfo setter = MethodInfo.from(setters[i]);
                int diff = i - lastIndex;
                if (diff > 0) {
                    e.iinc(index, diff);
                    lastIndex = i;
                }
                e.dup2();
                e.aaload(i);
                e.unbox(setter.getSignature().getArgumentTypes()[0]);
                e.invoke(setter);
                switch (setter.getSignature().getReturnType().getSort()) {
                    case 0: {
                        continue block4;
                    }
                    case 7: 
                    case 8: {
                        e.pop2();
                        continue block4;
                    }
                    default: {
                        e.pop();
                    }
                }
            }
            handler.end();
            e.returnValue();
            e.catchException(handler, Type.TYPE_THROWABLE);
            e.newInstance(BULK_BEAN_EXCEPTION);
            e.dupX1();
            e.swap();
            e.loadLocal(index);
            e.invokeConstructor(BULK_BEAN_EXCEPTION, CSTRUCT_EXCEPTION);
            e.throwException();
        } else {
            e.returnValue();
        }
        e.end_method();
    }

    private static void validate(Class target, String[] getters, String[] setters, Class[] types, Method[] getters_out, Method[] setters_out) {
        int i = -1;
        if (setters.length != types.length || getters.length != types.length) {
            throw new BulkBeanException("accessor array length must be equal type array length", i);
        }
        for (i = 0; i < types.length; ++i) {
            Method method;
            if (getters[i] != null) {
                method = BulkBeanEmitter.getMethod(target, getters[i], null, i);
                if (method.getReturnType() != types[i]) {
                    throw new BulkBeanException("Specified type " + types[i] + " does not match declared type " + method.getReturnType(), i);
                }
                if (Modifier.isPrivate(method.getModifiers())) {
                    throw new BulkBeanException("Property is private", i);
                }
                getters_out[i] = method;
            }
            if (setters[i] == null) continue;
            method = BulkBeanEmitter.getMethod(target, setters[i], new Class[]{types[i]}, i);
            if (Modifier.isPrivate(method.getModifiers())) {
                throw new BulkBeanException("Property is private", i);
            }
            setters_out[i] = method;
        }
    }

    private static Method getMethod(Class<?> type, String methodName, Class<?>[] parameterTypes, int index) {
        Method method = ReflectionUtils.findMethod(type, methodName, parameterTypes);
        if (method == null) {
            throw new BulkBeanException("Cannot find specified property", index);
        }
        return method;
    }
}

