/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.bytecode.beans;

import cn.taketoday.bytecode.ClassVisitor;
import cn.taketoday.bytecode.beans.BeanMapEmitter;
import cn.taketoday.bytecode.core.AbstractClassGenerator;
import cn.taketoday.lang.Assert;
import cn.taketoday.util.ReflectionUtils;
import java.security.ProtectionDomain;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class BeanMap
extends AbstractMap<String, Object>
implements Map<String, Object> {
    public static final int REQUIRE_GETTER = 1;
    public static final int REQUIRE_SETTER = 2;
    protected Object bean;

    public static BeanMap create(Object bean) {
        Generator gen = new Generator();
        gen.setBean(bean);
        return gen.create();
    }

    public abstract BeanMap newInstance(Object var1);

    public abstract Class getPropertyType(String var1);

    protected BeanMap() {
    }

    protected BeanMap(Object bean) {
        this.setBean(bean);
    }

    @Override
    public Object get(Object key) {
        return this.get(this.bean, key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.put(this.bean, key, value);
    }

    public abstract Object get(Object var1, Object var2);

    public abstract Object put(Object var1, Object var2, Object var3);

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object key : this.keySet()) {
            Object v = this.get(key);
            if (!Objects.equals(value, v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        for (String string : t.keySet()) {
            this.put(string, t.get(string));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o != this) {
            if (!(o instanceof Map)) {
                return false;
            }
            Map other = (Map)o;
            if (this.size() != other.size()) {
                return false;
            }
            for (Object key : this.keySet()) {
                if (Objects.equals(this.get(key), other.get(key))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int code = 0;
        for (Object key : this.keySet()) {
            code += Objects.hashCode(key) ^ Objects.hashCode(this.get(key));
        }
        return code;
    }

    @Override
    public Set entrySet() {
        HashMap copy = new HashMap();
        for (Object key : this.keySet()) {
            copy.put(key, this.get(key));
        }
        return Collections.unmodifiableSet(copy.entrySet());
    }

    @Override
    public Collection<Object> values() {
        Set keys = this.keySet();
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (Object key : keys) {
            values.add(this.get(key));
        }
        return Collections.unmodifiableCollection(values);
    }

    static final class Generator
    extends AbstractClassGenerator {
        private Object bean;
        private Class beanClass;
        private int require;

        public Generator() {
            super(BeanMap.class);
        }

        public void setBean(Object bean) {
            this.bean = bean;
            if (bean != null) {
                this.beanClass = bean.getClass();
                this.setNeighbor(this.beanClass);
            } else {
                this.setNeighbor(null);
            }
        }

        public void setBeanClass(Class beanClass) {
            this.beanClass = beanClass;
            this.setNeighbor(beanClass);
        }

        public void setRequire(int require) {
            this.require = require;
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.beanClass.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectionUtils.getProtectionDomain(this.beanClass);
        }

        public BeanMap create() {
            Assert.notNull((Object)this.beanClass, "Class of bean unknown");
            this.setNamePrefix(this.beanClass.getName());
            return (BeanMap)super.create(new BeanMapKey(this.beanClass, this.require));
        }

        @Override
        public void generateClass(ClassVisitor v) throws Exception {
            new BeanMapEmitter(v, this.getClassName(), this.beanClass, this.require);
        }

        protected Object firstInstance(Class type) {
            return ((BeanMap)ReflectionUtils.newInstance(type)).newInstance(this.bean);
        }

        @Override
        protected Object nextInstance(Object instance) {
            return ((BeanMap)instance).newInstance(this.bean);
        }

        record BeanMapKey(Class type, int require) {
        }
    }
}

