/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.jni;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.pytorch.engine.PtNDArray;
import ai.djl.pytorch.engine.PtNDManager;
import ai.djl.pytorch.engine.PtSymbolBlock;
import ai.djl.pytorch.jni.Pointer;
import ai.djl.pytorch.jni.PyTorchLibrary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class IValueUtils {
    private IValueUtils() {
    }

    public static Pointer toIValuePointer(PtNDArray array) {
        return PyTorchLibrary.LIB.iValueCreateFromTensor(array.getHandle());
    }

    public static boolean isNDArray(Pointer iValueHandle) {
        return PyTorchLibrary.LIB.iValueIsTensor(iValueHandle);
    }

    public static boolean isNDList(Pointer iValueHandle) {
        return PyTorchLibrary.LIB.iValueIsTensorList(iValueHandle);
    }

    public static boolean isArray(Pointer iValueHandle) {
        return PyTorchLibrary.LIB.iValueIsList(iValueHandle);
    }

    public static boolean isTuple(Pointer iValueHandle) {
        return PyTorchLibrary.LIB.iValueIsTuple(iValueHandle);
    }

    public static boolean isMap(Pointer iValueHandle) {
        return PyTorchLibrary.LIB.iValueIsMap(iValueHandle);
    }

    public static boolean isString(Pointer iValueHandle) {
        return PyTorchLibrary.LIB.iValueIsString(iValueHandle);
    }

    public static PtNDArray toNDArray(Pointer iValueHandle, PtNDManager manager) {
        Pointer ndHandle = PyTorchLibrary.LIB.iValueToTensor(iValueHandle);
        return manager.create(ndHandle);
    }

    public static NDList toNDList(Pointer iValueHandle, PtNDManager manager) {
        Pointer[] ndHandles = PyTorchLibrary.LIB.iValueToTensorList(iValueHandle);
        NDList list = new NDList();
        for (Pointer handle : ndHandles) {
            list.add((Object)manager.create(handle));
        }
        return list;
    }

    public static String toString(Pointer iValueHandle) {
        return PyTorchLibrary.LIB.iValueToString(iValueHandle);
    }

    public static Pointer[] toIValueArray(Pointer iValueHandle) {
        if (IValueUtils.isTuple(iValueHandle)) {
            return PyTorchLibrary.LIB.iValueToListFromTuple(iValueHandle);
        }
        return PyTorchLibrary.LIB.iValueToList(iValueHandle);
    }

    public static Map<Pointer, Pointer> toIValueMap(Pointer iValueHandle) {
        Pointer[] iValueHandles = PyTorchLibrary.LIB.iValueToMap(iValueHandle);
        ConcurrentHashMap<Pointer, Pointer> map = new ConcurrentHashMap<Pointer, Pointer>();
        for (int i = 0; i < iValueHandles.length; i += 2) {
            map.put(iValueHandles[i], iValueHandles[i + 1]);
        }
        return map;
    }

    private static NDList forwardHelper(Pointer iValueHandle, PtNDManager manager) {
        NDList list = new NDList();
        if (IValueUtils.isNDArray(iValueHandle)) {
            list.add((Object)IValueUtils.toNDArray(iValueHandle, manager));
        } else if (IValueUtils.isNDList(iValueHandle)) {
            list.addAll(IValueUtils.toNDList(iValueHandle, manager));
        } else if (IValueUtils.isTuple(iValueHandle) || IValueUtils.isArray(iValueHandle)) {
            Pointer[] results;
            for (Pointer ptr : results = IValueUtils.toIValueArray(iValueHandle)) {
                list.addAll(IValueUtils.forwardHelper(ptr, manager));
            }
        } else if (IValueUtils.isMap(iValueHandle)) {
            Map<Pointer, Pointer> map = IValueUtils.toIValueMap(iValueHandle);
            for (Map.Entry<Pointer, Pointer> entry : map.entrySet()) {
                String name = IValueUtils.toString(entry.getKey());
                PyTorchLibrary.LIB.torchDeleteIValue(entry.getKey());
                PtNDArray value = IValueUtils.toNDArray(entry.getValue(), manager);
                PyTorchLibrary.LIB.torchDeleteIValue(entry.getValue());
                value.setName(name);
                list.add((Object)value);
            }
        } else {
            PyTorchLibrary.LIB.torchDeleteIValue(iValueHandle);
            throw new UnsupportedOperationException("Unsupported IValue type");
        }
        PyTorchLibrary.LIB.torchDeleteIValue(iValueHandle);
        return list;
    }

    public static NDList forward(PtSymbolBlock block, NDList inputs) {
        Pointer[] arrayHandles = (Pointer[])inputs.stream().map(input -> ((PtNDArray)input).getHandle()).toArray(Pointer[]::new);
        Pointer result = PyTorchLibrary.LIB.moduleForward(block.getHandle(), arrayHandles);
        PtNDManager manager = (PtNDManager)((NDArray)inputs.get(0)).getManager();
        return IValueUtils.forwardHelper(result, manager);
    }
}

